/*
oliver, 03.08.2022.
В эталонной БД (studium) была создана функция xp_fget_rus_month(timestamp without time zone, boolean)
со вторым параметром, равным True по умолчанию. Поэтому она может вызываться вместо прежней одноимённой
без указания дополнительного параметра. Однако во избежание конфликта имён необходимо удалить прежнюю
одноимённую функцию xp_fget_rus_month(timestamp without time zone):
    DROP FUNCTION xp_fget_rus_month(timestamp without time zone);
*/

DO $$
declare
  _old_exists boolean;
  _db_name varchar(63);
  _msg varchar(255);

BEGIN
  SELECT exists(select 1 from pg_proc where proname = 'xp_fget_rus_month' and proargnames = array['d'])
  INTO _old_exists;

  SELECT current_database()
  INTO _db_name;

  _msg := 'БД ' || _db_name || '.' || E'\n';

  if (_old_exists) then
    DROP FUNCTION xp_fget_rus_month(timestamp without time zone);
    _msg := _msg || 'Дропнули старую функцию xp_fget_rus_month.' || E'\n';

    SELECT exists(select 1 from pg_proc where proname = 'xp_fget_rus_month' and proargnames = array['d'])
    INTO _old_exists;

    if (_old_exists) then
      _msg := _msg || 'ПЛОХО! Старая функция уцелела.';
    end if;
  else
    _msg := _msg || 'Старой функции xp_fget_rus_month здесь нет.';
  end if;

raise notice '%', _msg;

END $$;
