from sqlalchemy.orm import sessionmaker
from sqlalchemy.sql import text

from flask import current_app

from LMSAPI.api.Models.File import File


class Announcement:
    def __init__(self, lname):
        self.lname = lname
        engine = current_app.ms.db(self.lname)
        Session = sessionmaker(bind=engine)
        self.session = Session()

    def get_all_announcements(self, mid, beg_date, end_date):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
        SELECT DISTINCT
            p.postid,
            p."name",
            p.posted,
            COALESCE(c.title, 'Общее') AS discipline,
            et.ev_type,
            p.text,
            CASE
                WHEN p.mid <> :mid AND COALESCE(ar.readed, 0) > 0 THEN FALSE
                WHEN p.mid <> :mid AND COALESCE(ar.readed, 0) = 0 THEN TRUE
            ELSE NULL
            END AS is_read,
            CASE
                WHEN p.mid = :mid THEN 'Исходящее'
            ELSE 'Входящее' END
            AS type_departure,
            xp_f_get_mid_fio(p.mid, :mid) AS sender,
            CASE p.announcment_type
                WHEN 0 THEN 'Служебное'
            ELSE 'Публичное'
            END AS type_announcement
        FROM posts3 p
        LEFT OUTER JOIN courses c ON c.cid = p.cid
        LEFT OUTER JOIN xp_evenntypes et ON et.ev_type_id=p.ev_type_id
        LEFT JOIN announcement_recipients ar ON ar.announcement = p.postid
        WHERE
        COALESCE(p.cid, 0) >= -1
        AND CASE
            WHEN p.announcment_type = 0 THEN p.posted BETWEEN :beg_date AND :end_date
        ELSE p.public_date_from BETWEEN :beg_date AND :end_date OR p.public_date_to BETWEEN :beg_date AND :end_date
        END
        AND (COALESCE(ar.mid, 0) = :mid OR p.announcment_type = 1) -- получатель или публичное
        OR (p.mid = :mid AND p.posted BETWEEN :beg_date AND :end_date) -- или отправитель
        """

        stmt = text(sql)
        query = conn.execute(stmt, {"mid": mid, "beg_date": beg_date, "end_date": end_date})

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_announcement(self, post_id, mid):
        conn = current_app.ms.db(self.lname).connect()

        sql = """SELECT * FROM posts3 WHERE postid=:post_id"""

        stmt = text(sql)
        query = conn.execute(stmt, {"post_id": post_id}).first()

        if query is None:
            return None

        result = dict(query)

        sql = """
        SELECT * 
        FROM post_parts 
        WHERE post = :post_id
        """

        stmt = text(sql)
        query = conn.execute(stmt, {"post_id": post_id})

        result["chapters"] = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        if result.get('announcment_type'):
            sql = """
            INSERT INTO announcement_recipients (announcement, mid, readed, sended, gid)
            SELECT
            postid, :mid, 1, mid, NULL
            FROM posts3 p3
            WHERE p3.postid = :post_id
            AND NOT EXISTS (SELECT 1 FROM announcement_recipients WHERE announcement = p3.postid AND mid = :mid);
            """
        else:
            sql = """
            UPDATE announcement_recipients
            SET readed = 1
            WHERE mid = :mid /*AND sended > 0*/ AND readed = 0;
            """

        trans = conn.begin()
        stmt = text(sql)
        conn.execute(stmt, {"post_id": post_id, "mid": mid})
        trans.commit()

        return result

    @staticmethod
    def get_announcement_image_path(lname: str, post_id: int):
        file = File(lname)
        return file.getNewsDirectory(post_id)

    def how_many_unread_announcement(self, mid):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
        SELECT COUNT(p3.postid)
        FROM posts3 p3
        LEFT JOIN announcement_recipients ar ON ar.announcement = p3.postid
        WHERE
        CASE p3.announcment_type 
            WHEN 0 THEN p3.mid <> :mid AND ar.mid = :mid AND ar.sended > 0 AND ar.readed = 0
        ELSE p3.mid <> :mid AND COALESCE(ar.readed, 0) = 0 AND
            NOW() BETWEEN p3.public_date_from AND p3.public_date_to
        END; 
        """

        stmt = text(sql)
        query = conn.execute(stmt, {"mid": mid})
        count = query.scalar()

        return count
