# LMSAPI/API/Faculty.py
import os
from decimal import Decimal

from sqlalchemy import create_engine
from sqlalchemy.sql import text

import config
from LMSAPI.api.Models.File import File
from LMSAPI.api.Models.User import User
from flask import current_app
import pickle


class Buildings:
    def __init__(self, cname):
        self.lname = cname

    def get_all_buildings(self):
        sql = (
            """
            SELECT *
            FROM training_facilites_objects;
            """
        )

        stmt = text(sql)

        return self.return_result(stmt, self.lname)

    @staticmethod
    def return_result(stmt, lname):
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(stmt)
        res = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        for r in res:
            for key, value in r.items():
                if isinstance(value, Decimal):
                    r[key] = float(value)

        return res
