# LMSAPI/API/Faculty.py
import os

from sqlalchemy import create_engine
from sqlalchemy.sql import text

import config
from LMSAPI.api.Models.File import File
from LMSAPI.api.Models.User import User
from flask import current_app, g
import pickle


class Cathedra:
    def __init__(self, cname):
        self.idcathedra = 0
        self.faculty = 0
        self.cathedra = ""
        self.lname = cname

    def serialize(self):
        return {
            "idcathedra": self.idcathedra,
            "cathedra": self.cathedra,
            "faculty": self.faculty,
        }

    def get_cathedra_list_from_redis(self, facultyid):
        cachedClist = current_app.ms.redis(self.lname).get("SYSCALIST" + str(facultyid))
        if cachedClist is not None:
            clist = pickle.loads(cachedClist)
            return clist
        return

    def set_cathedra_list_to_redis(self, clist, facultyid):
        current_app.ms.redis(self.lname).setex(
            "SYSCALIST" + str(facultyid), 5, pickle.dumps(clist)
        )
        return

    def get_cathedra_from_redis(self, id):
        cachedClist = current_app.ms.redis(self.lname).get("FA" + str(id))
        if cachedClist is not None:
            clist = pickle.loads(cachedClist)
            return clist
        return

    def set_cathedra_to_redis(self, result):
        current_app.ms.redis(self.lname).setex(
            "CA" + str(result["cathedra"][0]["idcathedra"]), 5, pickle.dumps(result)
        )
        return

    def getCathedra(self, id):
        result = self.get_cathedra_from_redis(id)

        if result is not None:
            return result

        conn = current_app.ms.db(self.lname).connect()

        stmt = text("select * from cathedras where idcathedra=:id")
        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)

        result = {"cathedra": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        if len(result["cathedra"]) == 0:
            return None

        Chief = User(self.lname)

        Chief = Chief.get_user_from_sql_id(result["cathedra"][0]["Chief"])
        if Chief is not None:
            result["cathedra"][0]["Chief"] = Chief.serialize()

        result["cathedra"][0]["divisions"] = self.get_divisions(self.lname, id)
        result["cathedra"][0]["specialties"] = self.get_specialties(self.lname, id)
        result["cathedra"][0]["disciplines"] = self.get_disciplines(self.lname, id)
        result["cathedra"][0]["modules"] = self.get_modules(self.lname, id)
        result["cathedra"][0]["additionalWork"] = None
        result["cathedra"][0]["staff"] = self.get_staff(self.lname, id)
        result["cathedra"][0]["files"] = self.get_files(self.lname, id)

        result["cathedra"][0]["staff_num"] = len(result["cathedra"][0]["staff"])
        self.set_cathedra_to_redis(result)

        return result

    def getCathedraList(self, faculty):
        c = Cathedra(self.lname)

        cathedraList = c.get_cathedra_list_from_redis(faculty)

        if cathedraList is not None:
            return cathedraList
        conn = current_app.ms.db(self.lname).connect()

        if faculty == 0:
            stmt = text(
                "select idcathedra,cathedra,faculty from cathedras "
                "where state='Действующая' "
                "order by For_Sorted_With_Numder4(cathedra)"
            )
        else:
            stmt = text(
                "select idcathedra,cathedra,faculty from cathedras where faculty=:id and state='Действующая' "
                "order by For_Sorted_With_Numder4(cathedra)"
            )
            stmt = stmt.bindparams(id=faculty)

        query = conn.execute(stmt)

        cathedraList = []

        for row in query:
            rcathedra = Cathedra("")
            rcathedra.idcathedra = row.idcathedra
            rcathedra.cathedra = row.cathedra
            rcathedra.faculty = row.faculty
            cathedraList.append(rcathedra)

        c.set_cathedra_list_to_redis(cathedraList, faculty)

        return cathedraList

    @staticmethod
    def get_cathedra_list_user(lname, mid):
        """returns a list of the user's cathedras"""
        sql = """
            SELECT cathedra, pe.mid FROM cathedras ca
                JOIN groupname gn ON gn.idcathedra = ca.idcathedra
                JOIN groupuser gu ON gu.gid = gn.gid
                JOIN people pe ON pe.mid = gu.mid
            WHERE pe.mid = :mid
            """
        conn = current_app.ms.db(lname).connect()
        stmt = text(sql)
        stmt = stmt.bindparams(mid=mid)
        query = conn.execute(stmt)

        cathedra_user = []

        for row in query:
            cathedra = Cathedra("")
            cathedra.cathedra = row.cathedra
            cathedra_user.append(cathedra)

        return cathedra_user

    def getCathedraListForTeacher(self, faculty, mid):
        c = Cathedra(self.lname)

        cathedraList = c.get_cathedra_list_from_redis(faculty)

        if cathedraList is not None:
            return cathedraList

        conn = current_app.ms.db(self.lname).connect()

        if faculty == 0:
            sql = """select distinct c.idcathedra,c.cathedra,c.faculty 
                    from cathedras c
                    inner join cathedra_personnel cp on cp.cid = c.idcathedra
                    where  cp.mid = :mid
                    order by c.cathedra"""
            stmt = text(sql)
            stmt = stmt.bindparams(mid=mid)
            if g.user.user_is_rasdel_admin(
                g.user.mid, "Журнал учета учебных занятий. Администратор"
            ):
                sql = """select distinct c.idcathedra,c.cathedra,c.faculty 
                    from cathedras c
                    inner join cathedra_personnel cp on cp.cid = c.idcathedra
                    order by c.cathedra"""
                stmt = text(sql)
        else:
            sql = """select distinct c.idcathedra,c.cathedra,c.faculty 
                    from cathedras c
                    inner join cathedra_personnel cp on cp.cid = c.idcathedra
                    where  faculty=:id and cp.mid = :mid
                    order by c.cathedra"""
            stmt = text(sql)
            stmt = stmt.bindparams(mid=mid)
            if g.user.user_is_rasdel_admin(
                g.user.mid, "Журнал учета учебных занятий. Администратор"
            ):
                sql = """select distinct c.idcathedra,c.cathedra,c.faculty 
                    from cathedras c
                    inner join cathedra_personnel cp on cp.cid = c.idcathedra
                    where  faculty=:id
                    order by c.cathedra"""
                stmt = text(sql)
            stmt = stmt.bindparams(id=faculty)

        query = conn.execute(stmt)

        cathedraList = []

        for row in query:
            rcathedra = Cathedra("")
            rcathedra.idcathedra = row.idcathedra
            rcathedra.cathedra = row.cathedra
            rcathedra.faculty = row.faculty
            cathedraList.append(rcathedra)

        c.set_cathedra_list_to_redis(cathedraList, faculty)

        return cathedraList

    def get_cathedra_list_for_teacher_journal_of_accounting_of_training_sessions(self, faculty):
        c = Cathedra(self.lname)

        conn = current_app.ms.db(self.lname).connect()

        sql = """
        
        SELECT idcathedra, coalesce(nullif("ShortName",''),cathedra) as cathedra
        FROM cathedras
        WHERE (faculty = :faculty or :faculty<=0)
            AND cathtype >= 0 
            AND (
                state = 'Действующая' 
                or COALESCE(
                      (SELECT CONVERT_FROM(value, 'UTF8') FROM options WHERE name = 'showhidendivisions') = 'true', false
                    ) = true
            )
        ORDER BY (substring(cathedra, '^[0-9]+'))::bigint , substring(cathedra, '[^0-9_].*$');
        """
        stmt = text(sql)
        stmt = stmt.bindparams(faculty=faculty)

        query = conn.execute(stmt)

        # cathedraList = []
        #
        # for row in query:
        #     rcathedra = Cathedra("")
        #     rcathedra.idcathedra = row.idcathedra
        #     rcathedra.cathedra = row.cathedra
        #     rcathedra.faculty = row.faculty
        #     cathedraList.append(rcathedra)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def addCathedra(self, facultyid, cathedra):
        conn = current_app.ms.db(self.lname).connect()

        sql = """INSERT INTO cathedras(
                faculty, cathedra, state, "ShortName")
                VALUES (:faculty, :cathedra, :state, :shortname);"""
        stmt = text(sql)

        stmt = stmt.bindparams(faculty=facultyid)
        stmt = stmt.bindparams(cathedra=cathedra["cathedra"])
        stmt = stmt.bindparams(state=cathedra["state"])
        stmt = stmt.bindparams(shortname=cathedra["shortname"])

        conn.execute(stmt)

        sql = "SELECT currval(pg_get_serial_sequence('cathedras','idcathedra'))"
        stmt = text(sql)
        query = conn.execute(stmt)
        newId = 0
        for row in query:
            newId = row.currval

        return newId

    def get_divisions(self, lname, cathedra_id):
        sql = """
        select d.name, p.fio
        from vw_divisions d
        left join cathedras c on c.idcathedra | 536870912 = d.owner_dep
        left join departments dp on d.id=dp.did
        left join vw_people p on p.mid=dp.mid
        where c.idcathedra=:cathedra_id and d.owner_dep = c.idcathedra | 536870912
        order by c.idcathedra
        """
        stmt = text(sql)
        stmt = stmt.bindparams(cathedra_id=cathedra_id)
        return Cathedra.return_result(stmt, lname)

    def get_specialties(self, lname, cathedra_id):
        sql = """
                    SELECT l.l_cath_milprof AS id, m.mpid, m.shortname AS voen_spec_kratko, e.dir_reg_num AS fgos, q0.d_num AS kt, e."Gen_GOS" AS pokolenie, 
                    COALESCE(q1.qty_groups, 0) AS grupp, q2.trdir_name AS napravl_podgotov 
                    FROM l_cath_milprof AS l
                    JOIN militaryprofession AS m ON m.mpid = l.f_militaryprofession 
                    LEFT JOIN  edu_direction AS e ON e.edu_direct_id = m.edu_direct_id
                    LEFT JOIN  ( 
                        SELECT q.mpid, STRING_AGG (q.d_num, '') AS d_num 
                        FROM qualif_demands AS q 
                        JOIN l_cath_milprof AS l ON l.f_militaryprofession = q.mpid 
                        WHERE l.f_cathedras = :cathedra_id
                        GROUP BY q.mpid 
                    ) AS q0 ON q0.mpid = m.mpid 
                    LEFT JOIN ( 
                        SELECT g.f_militaryprofession, g.idcathedra, COUNT(1) AS qty_groups 
                        FROM groupname AS g 
                        LEFT JOIN school_year AS s ON s.xp_key = g.yeargraduation 
                        WHERE g.yeargraduation = 0 OR NOW() BETWEEN s.begdate AND s.enddate 
                        GROUP BY g.f_militaryprofession, g.idcathedra 
                    ) AS q1 ON q1.f_militaryprofession = l.f_militaryprofession AND q1.idcathedra = l.f_cathedras
                    LEFT JOIN ( 
                        SELECT m.mpid, training_index || training_direct AS trdir_name 
                        FROM militaryprofession AS m 
                        JOIN    edu_direction         AS e ON e.edu_direct_id = m.edu_direct_id 
                        JOIN    training_directions   AS t ON t.training_direct_id = e.training_direct_id 
                    ) AS q2 ON q2.mpid = m.mpid 
                    WHERE l.f_cathedras = :cathedra_id
                    ORDER BY m.shortname;
        """

        stmt = text(sql)
        stmt = stmt.bindparams(cathedra_id=cathedra_id)
        return Cathedra.return_result(stmt, lname)

    def get_disciplines(self, lname, cathedra_id):
        sql = """
        SELECT c.cid as pid, c.title as name, l.c_edcycle as cycle, mc.name as metacourse 
        FROM courses c 
        INNER JOIN course2cathedra c2c ON c2c.cid = c.cid
        LEFT JOIN l_crs_cath_cycle l ON l.cid =  c.cid AND l.idcathedra = :cathedra_id
        LEFT JOIN meta_course mc ON mc.id = c.meta_course
        WHERE c2c.cathedraid = :cathedra_id
        """

        stmt = text(sql)
        stmt = stmt.bindparams(cathedra_id=cathedra_id)
        return Cathedra.return_result(stmt, lname)

    def get_modules(self, lname, id):
        sql = """
                    SELECT l.l_crs_cath_cycle as rowid, l.c_edcycle , c.name, c.number 
                    FROM l_crs_cath_cycle l 
                    JOIN c_edcycle c ON c.c_edcycle = l.c_edcycle 
                    WHERE l.cid IS NULL AND l.idcathedra = :id 
                    ORDER BY c.sorting,c.number, c.name
        """

        stmt = text(sql)
        stmt = stmt.bindparams(id=id)
        return Cathedra.return_result(stmt, lname)

    def get_additional_work(self, lname, cathedra_id):
        pass

    def get_staff(self, lname, cathedra_id):
        sql = """
        DROP TABLE IF EXISTS tmpCP;
        CREATE TEMPORARY TABLE tmpCP (pid INTEGER, mid INTEGER, id INTEGER, mode INTEGER, adate DATE);

        SELECT cp.id, cp.date, cp.code, coalesce(pf.workstatus,'Совмещение') workstatus, pos.name as position, cp.rate, cp.pos_overlay,
        if(pf.mid is not null,pf."MilitaryRank", cp.military_rank) as rank, 
        if(pf.mid is not null,mrpf.short_title, mr.short_title) as rank_name, 
        if(pf.mid is not null, pf.vus, cp.vus) as vus, 
        if(pf.mid is not null, vpf.code, v.code) as vus_name, cp.tariff,
        if(pf.mid is not null,pf."OfficerTrainingLevelID",cp.c_officer_level) as off_lvl, 
        if(pf.mid is not null,colpf.shortname,col.shortname) as off_lvl_name, 
        xp_format_fio(p.lastname,p.firstname,p.patronymic,0)  as personnel_name,
        case when cp.deputy_mid>0 and now() between  cp.deputy_date_start and coalesce(cp.deputy_date_end,now()) 
        then 
        concat_ws(' ',xp_f_get_mid_fio(cp.deputy_mid,1), cp.deputy_type, 'с',to_char(cp.deputy_date_start,'dd.mm.yyyy'))
        else null 
        end as deputy 
        FROM (
        select 0 as mode, dp.dpid as id, dp.sdid as structid,dp.positionid,
        coalesce(t.adate,dp.date) as date, case 
        when t.id is not null 
        then t.mid 
        else dp.mid 
        end as mid, dp.pos_overlay,dp.rate, dp.c_officer_level, dp.military_rank, dp.tariff,dp.vus,dp.code,dp.code2,dp.code3, dp.deputy_mid, dp.deputy_date_start,dp.deputy_date_end, dp.deputy_type
        from division_personnel dp 
        LEFT JOIN tmpCP t ON t.id=dp.dpid AND t.mode=0 
        union select 1 as mode, dp.fpid as id, dp.facultyid as structid,dp.positionid, coalesce(t.adate,dp.date) as date,
        case 
        when t.id is not null 
        then t.mid else dp.mid 
        end as mid, dp.pos_overlay,dp.rate, dp.c_officer_level, dp.military_rank, dp.tariff,dp.vus,dp.code,dp.code2,dp.code3, dp.deputy_mid, dp.deputy_date_start,dp.deputy_date_end, dp.deputy_type 
        from faculty_personnel dp
        LEFT JOIN tmpCP t ON t.id=dp.fpid AND t.mode=1 
        union select 2 as mode, dp.cpid as id, dp.cid as structid,dp.positionid, coalesce(t.adate,dp.date) as date, 
        case 
        when t.id is not null 
        then t.mid 
        else dp.mid 
        end as mid, dp.pos_overlay,dp.rate, dp.c_officer_level,dp.military_rank,dp.tariff,dp.vus,dp.code,dp.code2,dp.code3, dp.deputy_mid, dp.deputy_date_start,dp.deputy_date_end, dp.deputy_type
        from cathedra_personnel dp 
        LEFT JOIN tmpCP t ON t.id=dp.cpid AND t.mode=2) cp 
        LEFT JOIN military_rank mr on cp.military_rank = mr.id_mil_rank 
        LEFT JOIN c_officer_level col on col.id = cp.c_officer_level 
        LEFT JOIN (select v.id,v.code from vus v 
        left join vus_custom vc on vc.code=v.code) as v on v.id = cp.vus 
        JOIN positions pos ON pos.pid=cp.positionid 
        LEFT JOIN people p ON p.mid=cp.mid 
        LEFT JOIN xp_personal_file pf ON pf.mid = p.mid AND pf."Position"=pos.pid
        LEFT JOIN military_rank mrpf on pf."MilitaryRank" = mrpf.id_mil_rank
        LEFT JOIN c_officer_level colpf on colpf.id = pf."OfficerTrainingLevelID" 
        LEFT JOIN (select v.id,v.code from vus v 
        left join vus_custom vc on vc.code=v.code) as vpf on vpf.id = pf.vus 
        WHERE cp.mode=2 AND cp.structid=:id
        ORDER BY pos.name,pos_overlay desc,rate desc,p.lastname,p.firstname;
        """

        stmt = text(sql)
        stmt = stmt.bindparams(id=cathedra_id)
        return Cathedra.return_result(stmt, lname)

    def get_files(self, lname, cathedra_id):
        return File(lname).get_cathedra_files(cathedra_id)

    @staticmethod
    def return_result(stmt, lname):
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_journal_cathedras(self):
        conn = current_app.ms.db(self.lname).connect()

        stmt = text(
            """
            select idcathedra, coalesce(nullif("ShortName",''),cathedra) as cathedra
            from cathedras
            where ( faculty = 0 or 0<=0 ) 
            and cathtype >= 0 AND (state = 'Действующая')
            order by (substring(cathedra, '^[0-9]+'))::bigint , substring(cathedra, '[^0-9_].*$');
            """
        )
        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_ktp_cathedras(self):
        conn = current_app.ms.db(self.lname).connect()

        stmt = text(
            """
            select cs.idCathedra, cs.Cathedra from cathedras cs 
             join l_cath_milprof c2m on c2m.f_cathedras=cs.idcathedra 
             join qualif_demands q on q.mpid=c2m.f_militaryprofession 
             join curriculum clm on clm.q_demand_id=q.q_demand_id 
             join curriculum_detail cd on cd.idcurriculum=clm.idcurriculum 
             join curriculum_course cc on cd.id_curr_detail=any(cc.id_curr_details || cc.id_curr_detail) 
            group by cs.idCathedra, cs.Cathedra 
            order by For_Sorted_With_Numder4(cs.Cathedra)::varchar (8)
            """
        )
        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_umk_cathedras(self):
        conn = current_app.ms.db(self.lname).connect()

        stmt = text(
            """
            SELECT idcathedra, coalesce(NULLIF("ShortName", ''), cathedra) 
            FROM cathedras 
            WHERE (idcathedra IN (SELECT idcathedra FROM l_mcourse_cathedra)) 
                AND (state = 'Действующая' or false) 
            ORDER BY for_sorted_with_numder4(coalesce(NULLIF("ShortName", ''), cathedra))
            """
        )
        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
