# LMSAPI/API/Faculty.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from LMSAPI.api.Models.User import User
from flask import current_app
import pickle, sys

class Company:

    def __init__(self):
        self.idcathedra=0
        self.faculty=0
        self.cathedra=""
   
    def getFromRedis(self,lname):
        cachedCompany = current_app.ms.redis(lname).get("COMPANY")
        if cachedCompany is not None:
            cc = pickle.loads(cachedCompany)
            return cc
        return

    def setToRedis(self,lname,cc):
        current_app.ms.redis(lname).setex("COMPANY",120,pickle.dumps(cc))
        return

    def getCompany(self,lname):

        cc = Company().getFromRedis(lname)
        if cc is not None:
            return cc

        result = {}
        result['GOU_Name'] = Company().getSetting(lname,"GOU_Name")
        result['Dep_Name'] = Company().getSetting(lname,"Dep_Name")
        result['address'] =  Company().getSetting(lname,"address")
        result['phones'] =  Company().getSetting(lname,"phones")
        result['logoutaction'] = Company().getSetting(lname, "logoutaction")

        Company().setToRedis(lname,result)

        return result

    def getСhiefs(self,lname):
        sql = """SELECT options.name, m.mid, positions.name, m.lastname, m.firstname, m.patronymic, 
                COALESCE(m.lastname, '')||  COALESCE(' '|| SUBSTRING(m.firstname, 1, 1)|| '.', '')|| COALESCE(' '|| SUBSTRING(m.patronymic, 1, 1)|| '.', '') as FIO, 
                pf."Position", mr.title as "MilitaryRank"
                FROM people m
                JOIN xp_personal_file pf ON pf.mid= m.mid
                JOIN options ON name in ('position', 'Zam1', 'Zam2', 'Zam3', 'Zam4', 'Zam5') AND  pf."Position"::text = encode((value::bytea), 'escape')::text
                JOIN positions ON  pf."Position" = positions.pid
                LEFT JOIN military_rank mr on pf."MilitaryRank" = mr.id_mil_rank
                ORDER BY options.name
            """    
        conn = current_app.ms.db(lname).connect()
        stmt = text(sql)
        query = conn.execute(stmt)

        result = {'chiefs': [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}
        return result        

    def getSetting(self,lname,setting):
        conn = current_app.ms.db(lname).connect()
        stmt = text("select value from options where name=:setting")
        stmt = stmt.bindparams(setting=setting)    
        query = conn.execute(stmt)

        for row in query:
            if row[0] is not None:
                if sys.version_info[0] < 3:
                    return str(row[0])
                else:
                    return str(row[0].tobytes().decode('utf-8'))
                #contentstr = file
                #return contentstr

        return None


    def getImage(self,lname,setting):

        conn = current_app.ms.db(lname).connect()
        
        stmt = text("select value from options where name=:setting")
        stmt = stmt.bindparams(setting=setting)    
        query = conn.execute(stmt)

        for row in query:
            if row[0] is not None:
                if sys.version_info[0] < 3:
                    file = row[0] #.tobytes()
                else:
                    file = row[0].tobytes()
                contentstr = file
                return contentstr

        return None
    
    def getHistoryList(self, lname, args):
        conn = current_app.ms.db(lname).connect()
        count = False
        
        if 'count' in args.keys():
            if (args['count']):
                count = True

        pagination = ""
        if 'paginateFrom' in args.keys():
            if 'maxResults' in args.keys():
                pagination = " LIMIT " + str(int(args['maxResults'])) + " OFFSET " + str(
                    int(args['paginateFrom'])) + " "

        if count:
            sql = "select count(*) from posts3 where cid = -10;"
        else:
            sql ="select * from posts3 where cid = -10 order by posted desc "+pagination+";"

        query = conn.execute(sql)
        historyList = [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]

        return historyList 
    
    def getHistoryPartsList(self, lname, id):
        conn = current_app.ms.db(lname).connect()
        sql ="select * from post_parts where post = "+str(id)+" order by sorting;"

        query = conn.execute(sql)
        historyPartsList = [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]

        return historyPartsList     
    
    def getInformationList(self, lname, args):
        conn = current_app.ms.db(lname).connect()
        count = False
        
        if 'count' in args.keys():
            if (args['count']):
                count = True

        pagination = ""
        if 'paginateFrom' in args.keys():
            if 'maxResults' in args.keys():
                pagination = " LIMIT " + str(int(args['maxResults'])) + " OFFSET " + str(
                    int(args['paginateFrom'])) + " "

        if count:
            sql = "select count(*) from posts3 where cid = -20;"
        else:
            sql ="select * from posts3 where cid = -20 order by posted desc "+pagination+";"

        query = conn.execute(sql)
        informationList = [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]

        return informationList 
    
    def getInformationPartsList(self, lname, id):
        conn = current_app.ms.db(lname).connect()
        sql ="select * from post_parts where post = "+str(id)+" order by sorting;"

        query = conn.execute(sql)
        informationPartsList = [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]

        return informationPartsList     