# LMSAPI/API/Faculty.py
import os

from sqlalchemy import create_engine
from sqlalchemy.sql import text

import config
from LMSAPI.api.Models.File import File
from LMSAPI.api.Models.User import User
from flask import current_app
import pickle


class EducationStandards:
    def __init__(self, cname):
        self.lname = cname

    def get_all_edu_stands(self):
        sql = (
            """
            SELECT edu_direct_id, training_direct_id, dir_reg_num,
                dir_reg_date, code, p_mastering_y, p_mastering_m, labour_intensity,
                dir_state, hours_total, time_of_development, theoretical_training, 
                sessions_count, study_training, practical_training,
                state_sertification, holidays, kt_time, teaching_load, 
                auditorium_min, auditorium_max, vacation_time, vacation_time_w,
                program_name, program_level, description, p_mastering_w,
                by_competences, specialization, prefix_comp, f_education_profiles,
                doctors_all, doctors_pro, equal_all, ranked_adj, ranked_all,
                ranked_pro, teachers_dir, teachers_org, kt_code, reserve,
                total_ze, discipline_dop, reserve_hrs, kt_appr_date, 
                oop_load, holidays_w3, teachers_pro, base_part, year_load,
                military_load, "Gen_GOS", "EduForm"
            FROM edu_direction;
            """
        )

        stmt = text(sql)

        return self.return_result(stmt, self.lname)

    @staticmethod
    def return_result(stmt, lname):
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
