from flask import current_app
from sqlalchemy import text

from LMSAPI.api.Models.File import File

class Hero:


    @staticmethod
    def get_heroes(lname):
        conn = current_app.ms.db(lname).connect()
        file = File(lname)

        stmt = text("""
            SELECT
                    posts3.postid,
                    posts3.text,
                    p.lastname,
                    p.firstname,
                    p.patronymic,
                    rank.title								rank,
                    posts3.is_student
                    
            FROM posts3
            INNER JOIN vw_people p ON p.mid = posts3.mid_about
            LEFT JOIN xp_personal_file pf ON pf.mid = p.mid
            LEFT JOIN military_rank rank ON rank.id_mil_rank = pf."MilitaryRank"
            WHERE (posts3.status IS NULL OR posts3.status = 0) AND posts3.cid = -100
        """)  
        query = conn.execute(stmt)

        result = [
            dict(dict(r), **{"files": file.getHeroFiles(r.postid)})
            for r in query
        ]
        return result
        