# LMSAPI/API/
from sqlalchemy.sql import text
from flask import current_app, g
from LMSAPI.api.Models.File import File
import sys


class Methodical:

    def __init__(self, cname):
        self.lname = cname

    def getMethodicalFacultyList(self):
        conn = current_app.ms.db(self.lname).connect()

        #sql = """
        #SELECT DISTINCT faculty.*, For_Sorted_With_Numder4(faculty.faculty) :: varchar (8) as sort
        #FROM faculty
        #INNER JOIN methodical_room R ON R.idfaculty = faculty.idfaculty
        #ORDER BY sort;
        #"""

        sql = """
        SELECT DISTINCT div.id idfaculty, div.kind, div.name faculty, For_Sorted_With_Numder4(div.name) :: varchar (8) as sort 
        FROM vw_divisions div
        INNER JOIN methodical_room R ON R.idfaculty = div.id
        ORDER BY div.kind DESC , sort
        """
        stmt = text(sql)
        query = conn.execute(stmt)
        methodicalfaculty = {'methodicalfaculty': [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        return methodicalfaculty

    def getMethodical(self, facultyid, studentid):

        where = ""
        if not g.user.isTeacher:
            where += "AND access_students = 1"
        else:
            where += "AND access_teachers = 1"

        conn = current_app.ms.db(self.lname).connect()
        sql = """
        SELECT
        R.mrid, R.mr_name, R.mr_parent,
        IF(R.mid = :studentid, 2, coalesce(A.access_id, 0)) AS access,
        (   SELECT Count(mrid) 
            FROM methodical_room 
            WHERE mr_isfile = 0 AND mr_parent = R.mrid
        ) AS HasChild
        FROM methodical_room R										
        LEFT JOIN methodical_access A ON A.mrid = R.mrid AND A.mid = :studentid
        WHERE R.mr_isfile = 0 AND idfaculty = :facultyid {where}
        ORDER BY R.sort_order, R.mr_name;
        """.format(where=where)

        stmt = text(sql)
        stmt = stmt.bindparams(facultyid=facultyid)
        stmt = stmt.bindparams(studentid=studentid)
        query = conn.execute(stmt)
        methodical = {'methodical': [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        return methodical

    def getMethodicalList(self, facultyid, studentid, mrid):
        conn = current_app.ms.db(self.lname).connect()

        where = ""
        if not g.user.isTeacher:
            where += "AND access_students = 1"
        else:
            where += "AND access_teachers = 1"

        sql = """
        SELECT  R.mrid, R.mr_name, R.mr_isfile,
        IF(R.mid = :studentid, 2, coalesce(A.access_id, 0)) AS access
        FROM methodical_room R
        LEFT JOIN methodical_access A ON A.mrid = R.mrid AND A.mid = :studentid
        WHERE R.mr_parent = :mrid AND R.idfaculty = :facultyid {where}
        ORDER BY R.mr_isfile, R.sort_order, R.mr_name;
        """.format(where=where)
        print(sql)
        stmt = text(sql)
        stmt = stmt.bindparams(facultyid=facultyid)
        stmt = stmt.bindparams(studentid=studentid)
        stmt = stmt.bindparams(mrid=mrid)
        query = conn.execute(stmt)

        if sys.version_info[0] < 3:
            import urllib
        else:
            import urllib.parse

        import mimetypes

        methodical = []
        for r in query:
            fdata = {'access': r.access, 'mr_isfile': r.mr_isfile, 'mr_name': r.mr_name,
                     'uuname': urllib.parse.quote(r.mr_name), 'type': mimetypes.guess_type(r.mr_name)[0],
                     'mrid': r.mrid}
            methodical.append(fdata)

        return methodical

    def getMethodFileLocation(self, mrid):

        f = File(self.lname).getBaseFileDirecotry()
        return f + "/MethodicalFiles/" + str(mrid)
