# coding=UTF-8
# LMSAPI/API/Faculty.py
import base64
from decimal import Decimal

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app, g
import pickle
from LMSAPI.api.Models.File import File


class UMKCourse:
    def __init__(self, cname):
        self.lname = cname

    def getfromredis(self, id):
        cachedGlist = current_app.ms.redis(self.lname).get("UMKC" + str(id))
        if cachedGlist is not None:
            # current_app.logger.debug('UMKCourse from cache '+ str(id))
            glist = pickle.loads(cachedGlist)
            return glist
        return

    def settoredis(self, cid, data):
        current_app.ms.redis(self.lname).setex(
            "UMKC" + str(cid), 60, pickle.dumps(data)
        )
        return

    def getfromredisdetail(self, cid, syid, idcurriculum, eyid):
        cName = (
            "UMKCD"
            + str(cid)
            + "-"
            + str(syid)
            + "-"
            + str(idcurriculum)
            + "-"
            + str(eyid)
        )
        cachedDetail = current_app.ms.redis(self.lname).get(cName)
        if cachedDetail is not None:
            # current_app.logger.debug('UMKCourse from cache '+ str(id))
            detail = pickle.loads(cachedDetail)
            return detail
        return

    @staticmethod
    def get_all_event_tools(lname):
        sql = """SELECT * FROM eventtools"""
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.fetchall()
        if not res:
            return False
        return [dict(item) for item in res]

    def settoredisdetail(self, cid, syid, idcurriculum, eyid, data):
        cName = (
            "UMKCD"
            + str(cid)
            + "-"
            + str(syid)
            + "-"
            + str(idcurriculum)
            + "-"
            + str(eyid)
        )
        current_app.ms.redis(self.lname).setex(cName, 60, pickle.dumps(data))
        return

    def getUMKCourse(self, cid, syid, idcurriculum, eyid):
        result = self.getfromredisdetail(cid, syid, idcurriculum, eyid)

        if result is not None:
            return result

        conn = current_app.ms.db(self.lname).connect()

        if eyid != 0:
            sql = """select  
max(ccd.order) "order", 
max(ccd.oid) oid, 
max(ccd.tlid) tlid, 
max(ccd.eyid) eyid,  
max(case when ccd.oid = -1 then 'Зачёт' when ccd.oid = -2 then 'Зачёт с оценкой' when ccd.oid = -3 then 'Экзамен' when ccd.oid = -4 then 'Курсовая работа'  else o.title end) title, 
max(o.title_index) title_index,
max(ey.name) as educationyear, 
max(tl.name) as termname, 0 as files, 
max(ccd.id_curriculum_course) id_curriculum_course,
max(cc.title) as curriculum_name , 
max(o2.oid) prev_oid, 
max(coalesce(o2.level, 0)) prev_level, 
max(coalesce(o2.title,'')) prev_title,
max(ccd.ind_with_lecturer)::text ind_with_lecturer,
max(ccd.interm_test)::text interm_test,
max(ccd.test)::text test,
max(ccd.independent_work)::text independent_work,
max(ccd.control_work)::text control_work, 
(select 
 json_agg(json_build_object('hours', ccdh.hours, 'typeid', et.typeid, 'typename', et.typename, 'alias', et.alias, 'lessontype', et.lessontype,  'sorting', plc.sorting))
 from curriculum_course_detail_hours ccdh 
 inner join curriculum_course_details ccd2 on ccdh.id_curriculum_course_details = ccd2.id_curriculum_course_details
 inner join curriculum_course cc2 on cc2.id_curriculum_course = ccd2.id_curriculum_course   
 JOIN curriculum_detail cd2 ON cd2.id_curr_detail = cc2.id_curr_detail 
 JOIN curriculum clm ON clm.idcurriculum=cd2.idcurriculum 
 JOIN qualif_demands qd ON qd.q_demand_id = clm.q_demand_id 
 JOIN MilitaryProfession mp ON mp.mpid = qd.mpid 
 JOIN edu_direction ed ON ed.edu_direct_id = mp.edu_direct_id 
 JOIN preparation_structure ps ON ps.ps_id = ed.program_level 
 JOIN program_lesson_classes plc ON plc.ps_id = ps.ps_id 
 JOIN eventtools et ON et.typeid = plc.lesson_class and et.typeid = ccdh.typeid
 where ccdh.id_curriculum_course_details = ccd.id_curriculum_course_details
) hours,
-- max(ctd.id) as lesson_id,
json_agg(json_build_object('lesson_id', ctd.id, 'tema_num', ctd.tema_num, 'typename', et.typename, 'lesson', ctd.tema, 'additional_books', ctd.additional_books, 'questions', ctd.questions, 'books', ctd.books,'content', ctd.content,'homework', ctd.homework, 'hours', ctd.hours)) lessons
from curriculum_course_details ccd   
inner join curriculum_course cc on cc.id_curriculum_course = ccd.id_curriculum_course   
inner join curriculum_detail cd on cd.id_curr_detail = cc.id_curr_detail   
inner join curriculum c on c.idcurriculum = cd.idcurriculum   
inner join StudyYears2curriculum sy2c on sy2c.idcurriculum = c.idcurriculum 
inner join study_by_terms st on st.tlid = ccd.tlid and st.eyid = ccd.eyid and st.tt_type = 't' and st.id_curr_detail = cc.id_curr_detail   
left outer join organizations o on o.oid = ccd.oid 
inner join educationyears  ey on ey.eyid = ccd.eyid
join course_tema_detail ctd on ctd.id_curriculum_course_details = ccd.id_curriculum_course_details
join eventtools et on et.typeid = ctd.eventtool
inner join termslist tl on tl.tlid = ccd.tlid
left outer join organizations o2 on  o2.oid = o.prev_ref
where ccd.oid is not null 
and sy2c.syid = :syid and 
c.idcurriculum = :idcurriculum and  
cd.cid = :cid AND
ccd.eyid = :eyid 
group by ccd.id_curriculum_course_details 
order by ccd.order"""
            stmt = text(sql)
            stmt = stmt.bindparams(eyid=eyid)
        else:
            sql = """select  
max(ccd.order) "order", 
max(ccd.oid) oid, 
max(ccd.tlid) tlid, 
max(ccd.eyid) eyid,  
max(case when ccd.oid = -1 then 'Зачёт' when ccd.oid = -2 then 'Зачёт с оценкой' when ccd.oid = -3 then 'Экзамен' when ccd.oid = -4 then 'Курсовая работа'  else o.title end) title, 
max(o.title_index) title_index,
max(ey.name) as educationyear, 
max(tl.name) as termname, 0 as files, 
max(ccd.id_curriculum_course) id_curriculum_course,
max(cc.title) as curriculum_name , 
max(o2.oid) prev_oid, 
max(coalesce(o2.level, 0)) prev_level, 
max(coalesce(o2.title,'')) prev_title,
max(ccd.ind_with_lecturer)::text ind_with_lecturer,
max(ccd.interm_test)::text interm_test,
max(ccd.test)::text test,
max(ccd.independent_work)::text independent_work,
max(ccd.control_work)::text control_work,
(select 
 json_agg(json_build_object('hours', ccdh.hours, 'typeid', et.typeid, 'typename', et.typename, 'alias', et.alias, 'lessontype', et.lessontype))
 from curriculum_course_detail_hours ccdh 
 left outer join eventtools et on  et.typeid = ccdh.typeid
 where ccdh.id_curriculum_course_details = ccd.id_curriculum_course_details
) hours,
-- max(ctd.id) as lesson_id,
json_agg(json_build_object('lesson_id', ctd.id, 'tema_num', ctd.tema_num, 'typename', et.typename, 'lesson', ctd.tema, 'additional_books', ctd.additional_books, 'questions', ctd.questions, 'books', ctd.books,'content', ctd.content,'homework', ctd.homework, 'hours', ctd.hours)) lessons
from curriculum_course_details ccd   
inner join curriculum_course cc on cc.id_curriculum_course = ccd.id_curriculum_course   
inner join curriculum_detail cd on cd.id_curr_detail = cc.id_curr_detail   
inner join curriculum c on c.idcurriculum = cd.idcurriculum   
inner join StudyYears2curriculum sy2c on sy2c.idcurriculum = c.idcurriculum 
inner join study_by_terms st on st.tlid = ccd.tlid and st.eyid = ccd.eyid and st.tt_type = 't' and st.id_curr_detail = cc.id_curr_detail   
left outer join organizations o on o.oid = ccd.oid 
inner join educationyears  ey on ey.eyid = ccd.eyid
join course_tema_detail ctd on ctd.id_curriculum_course_details = ccd.id_curriculum_course_details
join eventtools et on et.typeid = ctd.eventtool
inner join termslist tl on tl.tlid = ccd.tlid
left outer join organizations o2 on  o2.oid = o.prev_ref
where ccd.oid is not null 
and sy2c.syid = :syid and 
c.idcurriculum = :idcurriculum and  
cd.cid = :cid
group by ccd.id_curriculum_course_details
order by ccd.order"""
            stmt = text(sql)

        stmt = stmt.bindparams(cid=cid)
        stmt = stmt.bindparams(syid=syid)
        stmt = stmt.bindparams(idcurriculum=idcurriculum)

        query = conn.execute(stmt)

        umkCourseDetailsResult = []

        id_curriculum_course = 0
        curriculum_name = ""

        for indx, umk in enumerate(
            [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        ):
            id_curriculum_course = umk["id_curriculum_course"]
            curriculum_name = umk["curriculum_name"]

            oid = umk.get("oid")
            tlid = umk.get("tlid")
            umk["files_count"] = 0

            umk["files"] = File(self.lname).listFiles(
                self.getUMKCourseFileLocation(id_curriculum_course, eyid, tlid, oid)
            )
            umk["files_count"] += len(umk["files"])

            if umk["lessons"][0].get("tema_num") is not None:
                umk["lessons"] = sorted(umk["lessons"], key=lambda k: k.get("tema_num") if k["tema_num"] is not None  else float('inf'))
            elif umk["lessons"][0].get("lesson") is not None:
                umk["lessons"] = sorted(
                    umk["lessons"],
                    key=lambda k: (
                        k.get("lesson").split()[1]
                        if len(k.get("lesson").split()) > 1 and k.get("lesson").split()[1].isdigit()
                        else k.get("lesson")
                    ),
                )

            for lesson in umk["lessons"]:
                if g.user.isTeacher:
                    lesson_files = self.getLessonFiles(lesson["lesson_id"])
                    lesson_files_plantable = self.get_lesson_files_plantable(lesson["lesson_id"])
                    files = lesson_files + lesson_files_plantable
                else:
                    lesson_student_files = self.get_lesson_student_files(lesson["lesson_id"])
                    lesson_files_plantable = self.get_lesson_files_plantable(lesson["lesson_id"])
                    files = lesson_student_files + lesson_files_plantable
                umk["files_count"] += len(files)
                lesson["files"] = File.check_for_links(
                    path=self.get_lesson_student_file_location(lesson["lesson_id"]),
                    files=files,
                )

            umkCourseDetailsResult.append(umk)

        # Get ey / tl pairs
        fileTerm = {}

        for eytl in umkCourseDetailsResult:
            fileTerm[eytl["eyid"]] = {}
        for eytl in umkCourseDetailsResult:
            fileTerm[eytl["eyid"]][eytl["tlid"]] = {}

        for eyId in fileTerm:
            for tlId in fileTerm[eyId]:
                semesterFiles = self.getUMKCourseFiles(
                    id_curriculum_course, eyId, tlId, "0"
                )
                testFiles = self.getUMKCourseFiles(
                    id_curriculum_course, eyId, tlId, "_1"
                )
                gradedTestFiles = self.getUMKCourseFiles(
                    id_curriculum_course, eyId, tlId, "_2"
                )
                exams = self.getUMKCourseFiles(id_curriculum_course, eyId, tlId, "_3")
                fileTerm[eyId][tlId] = {
                    "semesterFiles": semesterFiles,
                    "testFiles": testFiles,
                    "gradedTestFiles": gradedTestFiles,
                    "examFiles": exams,
                }

        umkTree = {}
        name = None
        prev_oid = 34
        prev_title = ""
        umkTree["Вне разделов"] = []
        for a in umkCourseDetailsResult:
            if a["prev_level"] == 0:
                name = a["prev_title"].strip()

                if name != "":
                    umkTree[name] = []

            if name is not None and name != "":
                umkTree[name].append(a)
            else:
                umkTree["Вне разделов"].append(a)

        if umkTree == {}:
            prev_oid = 34
            prev_title = "Основной раздел"
            umkTree["Основной раздел"] = []
            prev_level = 0
            order = 1
            for a in umkCourseDetailsResult:
                name = a["prev_title"].strip()
                if name == "":
                    name = a["title"]
                if a["prev_oid"] == None:
                    a["prev_oid"] = prev_oid
                    a["prev_title"] = prev_title
                prev_oid = a["oid"]
                prev_title = a["title"]
                a["prev_level"] = prev_level
                a["order"] = order
                umkTree["Основной раздел"].append(a)
                if prev_level == 0:
                    prev_level = 1
                order = order + 1

        data = {
            "umkCourseDetails": umkCourseDetailsResult,
            "commonFiles": fileTerm,
            "id_curriculum_course": id_curriculum_course,
            "curriculum_name": curriculum_name,
            "umkTree": umkTree,
        }

        self.settoredisdetail(cid, syid, idcurriculum, eyid, data)

        return data

    def getStudyYear(self, studyYear):
        conn = current_app.ms.db(self.lname).connect()
        stmt = text("select eyid from educationyears where number=:id")
        stmt = stmt.bindparams(id=studyYear)

        query = conn.execute(stmt)
        eyid = -1
        for row in query:
            eyid = row.eyid

        return eyid

    def get_xp_mid_grades_table_view(self, student_id):
        conn = current_app.ms.db(self.lname).connect()
        stmt = text(
            """
            SELECT xp_mid_grades_table(:student_id);
            SELECT xp_mid_grades_table_view(:student_id);
            SELECT * FROM tmp_mid_grades2_titles;
            """
        )
        stmt = stmt.bindparams(student_id=student_id)

        query = conn.execute(stmt)
        column_titles = {row["fieldname"]: row["title"] for row in query.fetchall()}
        return column_titles

    def get_xp_mid_grades_table(self, student_id):
        conn = current_app.ms.db(self.lname).connect()
        stmt = text(
            """
            SELECT xp_mid_grades_table(:student_id);
            SELECT xp_mid_grades_table_view_web(:student_id);
            SELECT * FROM tmp_mid_grades2_titles;
            SELECT * FROM tmp_mid_grades2 ORDER by processtypeid, mc_name;
            """
        )
        stmt = stmt.bindparams(student_id=student_id)

        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def getUMKCourses(self, cid):
        result = self.getfromredis(cid)

        if result is not None:
            return result

        conn = current_app.ms.db(self.lname).connect()

        # sql = """SELECT xp_fill_curriculum(:cid);
        #        SELECT cid, discipline, discipline_meta, hrs, with_lecturer, independent_work, fin_exam, fin_test, fin_test_with_grade, fin_test_work,
        #        s1::real,s2::real,s3::real,s4::real,s5::real,s6::real,s7::real,s8::real,s9::real,s10::real, i1::real,i2::real,i3::real,i4::real,i5::real,i6::real,i7::real,i8::real,i9::real,i10::real
        #        FROM tmp_plan
        #        WHERE cid !=0"""
        sql = """
                select xp_fill_curriculum_new2(:cid);
                SELECT  tmp_plan.cid, max(discipline) as discipline, max(mc.name) as discipline_meta, max(hrs) as hrs, max(with_lecturer) as with_lecturer, max(independent_work) as independent_work, max(fin_exam) as fin_exam, 
				max(fin_test) as fin_test, max(fin_test_with_grade) as fin_test_with_grade, max(fin_test_work) as fin_test_work,
				sum(case when pt.term_order = 1 and tt_type = 't' then trim_time else null end)::real as s1,
				sum(case when pt.term_order = 2 and tt_type = 't' then trim_time else null end)::real as s2,
				sum(case when pt.term_order = 3 and tt_type = 't' then trim_time else null end)::real as s3,
				sum(case when pt.term_order = 4 and tt_type = 't' then trim_time else null end)::real as s4,
				sum(case when pt.term_order = 5 and tt_type = 't' then trim_time else null end)::real as s5,
				sum(case when pt.term_order = 6 and tt_type = 't' then trim_time else null end)::real as s6,
				sum(case when pt.term_order = 7 and tt_type = 't' then trim_time else null end)::real as s7,
				sum(case when pt.term_order = 8 and tt_type = 't' then trim_time else null end)::real as s8,
				sum(case when pt.term_order = 9 and tt_type = 't' then trim_time else null end)::real as s9,
				sum(case when pt.term_order = 10 and tt_type = 't' then trim_time else null end)::real as s10,
				sum(case when pt.term_order = 1 and tt_type = 's' then trim_time else null end)::real as i1,
				sum(case when pt.term_order = 2 and tt_type = 's' then trim_time else null end)::real as i2,
				sum(case when pt.term_order = 3 and tt_type = 's' then trim_time else null end)::real as i3,
				sum(case when pt.term_order = 4 and tt_type = 's' then trim_time else null end)::real as i4,
				sum(case when pt.term_order = 5 and tt_type = 's' then trim_time else null end)::real as i5,
				sum(case when pt.term_order = 6 and tt_type = 's' then trim_time else null end)::real as i6,
				sum(case when pt.term_order = 7 and tt_type = 's' then trim_time else null end)::real as i7,
				sum(case when pt.term_order = 8 and tt_type = 's' then trim_time else null end)::real as i8,
				sum(case when pt.term_order = 9 and tt_type = 's' then trim_time else null end)::real as i9,
				sum(case when pt.term_order = 10 and tt_type = 's' then trim_time else null end)::real as i10
                FROM tmp_plan 
				left outer join courses c on c.cid = tmp_plan.cid
				left outer join meta_course mc on c.meta_course = mc.id
				left outer join tmp_plan_terms pt on pt.cid = tmp_plan.cid and pt.tt_type in ('t', 's')
                WHERE tmp_plan.cid !=0
				group by tmp_plan.cid
				order by discipline_meta, discipline"""

        stmt = text(sql)
        stmt = stmt.bindparams(cid=cid)
        query = conn.execute(stmt)

        data = {}

        dataK1S1 = []
        dataK1S2 = []
        dataK2S3 = []
        dataK2S4 = []
        dataK3S5 = []
        dataK3S6 = []
        dataK4S7 = []
        dataK4S8 = []
        dataK5S9 = []
        dataK5S10 = []

        ey1 = self.getStudyYear(1)
        ey2 = self.getStudyYear(2)
        ey3 = self.getStudyYear(3)
        ey4 = self.getStudyYear(4)
        ey5 = self.getStudyYear(5)

        for row in query:

            def get_semestr_data(
                i_hrs,
                s_hrs,
                row_fin_test_with_grade,
                str_fin_test_with_grade,
                row_fin_exam,
                str_fin_exam,
                row_fin_test,
                str_fin_test,
                row_fin_test_work,
                str_fin_test_work,
                semestr_number,
            ):
                dataKS = []
                obj = {}
                obj["cid"] = row.cid
                obj["discipline"] = row.discipline
                obj["discipline_meta"] = row.discipline_meta
                obj["i_hrs"] = i_hrs
                obj["s_hrs"] = s_hrs

                semestr_key = semestr_number

                stmts = text(
                    'select tlid from termslist where "number"::integer = :semestr_number'
                )
                stmts = stmts.bindparams(semestr_number=semestr_number)
                querys = conn.execute(stmts)
                for rows in querys:
                    semestr_key = rows.tlid

                if row_fin_test_with_grade is not None:
                    obj[str_fin_test_with_grade] = row_fin_test_with_grade
                    semestr_list = []
                    for i in row_fin_test_with_grade:
                        semestr_list.append(i)
                    if semestr_key in semestr_list:
                        obj[str_fin_test_with_grade] = True
                    else:
                        obj[str_fin_test_with_grade] = False
                else:
                    obj[str_fin_test_with_grade] = False

                if row_fin_exam is not None:
                    obj[str_fin_exam] = row_fin_exam
                    semestr_list = []
                    for i in row_fin_exam:
                        semestr_list.append(i)
                    if semestr_key in semestr_list:
                        obj[str_fin_exam] = True
                    else:
                        obj[str_fin_exam] = False
                else:
                    obj[str_fin_exam] = False

                if row_fin_test is not None:
                    obj[str_fin_test] = row_fin_test
                    semestr_list = []
                    for i in row_fin_test:
                        semestr_list.append(i)
                    if semestr_key in semestr_list:
                        obj[str_fin_test] = True
                    else:
                        obj[str_fin_test] = False
                else:
                    obj[str_fin_test] = False

                if row_fin_test_work is not None:
                    obj[str_fin_test_work] = row_fin_test_work
                    semestr_list = []
                    for i in row_fin_test_work:
                        semestr_list.append(i)
                    if semestr_key in semestr_list:
                        obj[str_fin_test_work] = True
                    else:
                        obj[str_fin_test_work] = False
                else:
                    obj[str_fin_test_work] = False

                dataKS.append(obj)
                return dataKS

            # semestr = {
            #             's1': row.s1,
            #             'i1': row.i1
            #
            # }
            # n = 0
            # while n < 10:
            #     n += 1
            #     if semestr.get('s1') is not None:
            #         data = get_semestr_data(i_hrs=semestr.get('i1'), s_hrs=semestr.get('s1'),
            #                                  row_fin_test_with_grade=row.fin_test_with_grade,
            #                                  str_fin_test_with_grade='fin_test_with_grade',
            #                                  row_fin_exam=row.fin_exam, str_fin_exam='fin_exam',
            #                                  row_fin_test=row.fin_test, str_fin_test='fin_test', semestr_number=n)
            #         data.append(data)

            if row.s1 is not None:
                data1 = get_semestr_data(
                    i_hrs=row.i1,
                    s_hrs=row.s1,
                    row_fin_test_with_grade=row.fin_test_with_grade,
                    str_fin_test_with_grade="fin_test_with_grade",
                    row_fin_exam=row.fin_exam,
                    str_fin_exam="fin_exam",
                    row_fin_test=row.fin_test,
                    str_fin_test="fin_test",
                    row_fin_test_work=row.fin_test_work,
                    str_fin_test_work="fin_test_work",
                    semestr_number=1,
                )
                dataK1S1.append(*data1)

            if row.s2 is not None:
                data2 = get_semestr_data(
                    i_hrs=row.i2,
                    s_hrs=row.s2,
                    row_fin_test_with_grade=row.fin_test_with_grade,
                    str_fin_test_with_grade="fin_test_with_grade",
                    row_fin_exam=row.fin_exam,
                    str_fin_exam="fin_exam",
                    row_fin_test_work=row.fin_test_work,
                    str_fin_test_work="fin_test_work",
                    row_fin_test=row.fin_test,
                    str_fin_test="fin_test",
                    semestr_number=2,
                )
                dataK1S2.append(*data2)

            if row.s3 is not None:
                data3 = get_semestr_data(
                    i_hrs=row.i3,
                    s_hrs=row.s3,
                    row_fin_test_with_grade=row.fin_test_with_grade,
                    str_fin_test_with_grade="fin_test_with_grade",
                    row_fin_exam=row.fin_exam,
                    str_fin_exam="fin_exam",
                    row_fin_test_work=row.fin_test_work,
                    str_fin_test_work="fin_test_work",
                    row_fin_test=row.fin_test,
                    str_fin_test="fin_test",
                    semestr_number=3,
                )
                dataK2S3.append(*data3)

            if row.s4 is not None:
                data4 = get_semestr_data(
                    i_hrs=row.i4,
                    s_hrs=row.s4,
                    row_fin_test_with_grade=row.fin_test_with_grade,
                    str_fin_test_with_grade="fin_test_with_grade",
                    row_fin_exam=row.fin_exam,
                    str_fin_exam="fin_exam",
                    row_fin_test_work=row.fin_test_work,
                    str_fin_test_work="fin_test_work",
                    row_fin_test=row.fin_test,
                    str_fin_test="fin_test",
                    semestr_number=4,
                )
                dataK2S4.append(*data4)

            if row.s5 is not None:
                data5 = get_semestr_data(
                    i_hrs=row.i5,
                    s_hrs=row.s5,
                    row_fin_test_with_grade=row.fin_test_with_grade,
                    str_fin_test_with_grade="fin_test_with_grade",
                    row_fin_exam=row.fin_exam,
                    str_fin_exam="fin_exam",
                    row_fin_test_work=row.fin_test_work,
                    str_fin_test_work="fin_test_work",
                    row_fin_test=row.fin_test,
                    str_fin_test="fin_test",
                    semestr_number=5,
                )
                dataK3S5.append(*data5)

            if row.s6 is not None:
                data6 = get_semestr_data(
                    i_hrs=row.i6,
                    s_hrs=row.s6,
                    row_fin_test_with_grade=row.fin_test_with_grade,
                    str_fin_test_with_grade="fin_test_with_grade",
                    row_fin_exam=row.fin_exam,
                    str_fin_exam="fin_exam",
                    row_fin_test_work=row.fin_test_work,
                    str_fin_test_work="fin_test_work",
                    row_fin_test=row.fin_test,
                    str_fin_test="fin_test",
                    semestr_number=6,
                )
                dataK3S6.append(*data6)

            if row.s7 is not None:
                data7 = get_semestr_data(
                    i_hrs=row.i7,
                    s_hrs=row.s7,
                    row_fin_test_with_grade=row.fin_test_with_grade,
                    str_fin_test_with_grade="fin_test_with_grade",
                    row_fin_exam=row.fin_exam,
                    str_fin_exam="fin_exam",
                    row_fin_test_work=row.fin_test_work,
                    str_fin_test_work="fin_test_work",
                    row_fin_test=row.fin_test,
                    str_fin_test="fin_test",
                    semestr_number=7,
                )
                dataK4S7.append(*data7)

            if row.s8 is not None:
                data8 = get_semestr_data(
                    i_hrs=row.i8,
                    s_hrs=row.s8,
                    row_fin_test_with_grade=row.fin_test_with_grade,
                    str_fin_test_with_grade="fin_test_with_grade",
                    row_fin_exam=row.fin_exam,
                    str_fin_exam="fin_exam",
                    row_fin_test_work=row.fin_test_work,
                    str_fin_test_work="fin_test_work",
                    row_fin_test=row.fin_test,
                    str_fin_test="fin_test",
                    semestr_number=8,
                )
                dataK4S8.append(*data8)

            if row.s9 is not None:
                data9 = get_semestr_data(
                    i_hrs=row.i9,
                    s_hrs=row.s9,
                    row_fin_test_with_grade=row.fin_test_with_grade,
                    str_fin_test_with_grade="fin_test_with_grade",
                    row_fin_exam=row.fin_exam,
                    str_fin_exam="fin_exam",
                    row_fin_test_work=row.fin_test_work,
                    str_fin_test_work="fin_test_work",
                    row_fin_test=row.fin_test,
                    str_fin_test="fin_test",
                    semestr_number=9,
                )
                dataK5S9.append(*data9)

            if row.s10 is not None:
                data10 = get_semestr_data(
                    i_hrs=row.i10,
                    s_hrs=row.s10,
                    row_fin_test_with_grade=row.fin_test_with_grade,
                    str_fin_test_with_grade="fin_test_with_grade",
                    row_fin_exam=row.fin_exam,
                    str_fin_exam="fin_exam",
                    row_fin_test_work=row.fin_test_work,
                    str_fin_test_work="fin_test_work",
                    row_fin_test=row.fin_test,
                    str_fin_test="fin_test",
                    semestr_number=10,
                )
                dataK5S10.append(*data10)

        if dataK1S1 != []:
            data["1 курс"] = {}
            data["1 курс"]["1 семестр"] = {}
            data["1 курс"]["1 семестр"]["courses"] = {}
            data["1 курс"]["1 семестр"]["courses"] = dataK1S1
            data["1 курс"]["eyid"] = ey1

        if dataK1S2 != []:
            data["1 курс"]["2 семестр"] = {}
            data["1 курс"]["2 семестр"]["courses"] = {}
            data["1 курс"]["2 семестр"]["courses"] = dataK1S2

        if dataK2S3 != []:
            data["2 курс"] = {}
            data["2 курс"]["3 семестр"] = {}
            data["2 курс"]["3 семестр"]["courses"] = {}
            data["2 курс"]["3 семестр"]["courses"] = dataK2S3
            data["2 курс"]["eyid"] = ey2

        if dataK2S4 != []:
            data["2 курс"]["4 семестр"] = {}
            data["2 курс"]["4 семестр"]["courses"] = {}
            data["2 курс"]["4 семестр"]["courses"] = dataK2S4

        if dataK3S5 != []:
            data["3 курс"] = {}
            data["3 курс"]["5 семестр"] = {}
            data["3 курс"]["5 семестр"]["courses"] = {}
            data["3 курс"]["5 семестр"]["courses"] = dataK3S5
            data["3 курс"]["eyid"] = ey3

        if dataK3S6 != []:
            data["3 курс"]["6 семестр"] = {}
            data["3 курс"]["6 семестр"]["courses"] = {}
            data["3 курс"]["6 семестр"]["courses"] = dataK3S6

        if dataK4S7 != []:
            data["4 курс"] = {}
            data["4 курс"]["7 семестр"] = {}
            data["4 курс"]["7 семестр"]["courses"] = {}
            data["4 курс"]["7 семестр"]["courses"] = dataK4S7
            data["4 курс"]["eyid"] = ey4

        if dataK4S8 != []:
            data["4 курс"]["8 семестр"] = {}
            data["4 курс"]["8 семестр"]["courses"] = {}
            data["4 курс"]["8 семестр"]["courses"] = dataK4S8


        if dataK5S9 != []:
            data["5 курс"] = {}
            data["5 курс"]["9 семестр"] = {}
            data["5 курс"]["9 семестр"]["courses"] = {}
            data["5 курс"]["9 семестр"]["courses"] = dataK5S9
            data["5 курс"]["eyid"] = ey5

        if dataK5S10 != []:
            data["5 курс"]["10 семестр"] = {}
            data["5 курс"]["10 семестр"]["courses"] = {}
            data["5 курс"]["10 семестр"]["courses"] = dataK5S10

        self.settoredis(cid, data)

        return data

    def convertOID(self, oid):
        if oid == "_1":
            return "-1"
        if oid == "_2":
            return "-2"
        if oid == "_3":
            return "-3"
        return oid

    def getUMKCourseFileLocation(self, idcurriculum, syid, tlid, oid):
        oid = self.convertOID(oid)
        f = File(self.lname).getBaseFileDirecotry()
        return (
            f
            + "/curriculum-course-details/"
            + str(idcurriculum)
            + "/"
            + str(syid)
            + "-"
            + str(tlid)
            + "/"
            + str(oid)
        )

    def getUMKCourseFiles(self, idcurriculum, syid, tlid, oid):
        oid = self.convertOID(oid)
        f = File(self.lname).listFiles(
            self.getUMKCourseFileLocation(idcurriculum, syid, tlid, oid)
        )
        return f

    def getLessonFileLocation(self, lesson_id):
        f = File(self.lname).getBaseFileDirecotry()
        return f + "/lesson_detail/" + str(lesson_id)

    def getLessonFiles(self, lesson_id):
        f = File(self.lname).listFiles(self.getLessonFileLocation(lesson_id))
        return f

    def get_lesson_file_location_plantable(self, lesson_id):
        f = File(self.lname).getBaseFileDirecotry()
        return f + "/lesson_detail/" + str(lesson_id) + "/plantable"

    def get_lesson_files_plantable(self, lesson_id):
        f = File(self.lname).listFiles(self.get_lesson_file_location_plantable(lesson_id))
        return f

    def get_lesson_student_file_location(self, lesson_id):
        f = File(self.lname).getBaseFileDirecotry()
        return f + "/lesson_detail/" + str(lesson_id) + "/students"

    def get_lesson_student_files(self, lesson_id):
        f = File(self.lname).listFiles(self.get_lesson_student_file_location(lesson_id))
        return f

    def getUMK(self, cid, idcurriculum, meta_course, idcathedra, xp_key):
        conn = current_app.ms.db(self.lname).connect()
        where = " "
        if cid is not None and cid != 0:
            where += """ AND (c.cid=:cid OR :cid=0)"""
        if idcurriculum is not None and idcurriculum != 0:
            where += """ AND (clm.idcurriculum=:idcurriculum OR :idcurriculum=0)"""
        if meta_course is not None and meta_course != 0:
            where += """ AND (c.meta_course=:meta_course OR :meta_course=0)"""
        if idcathedra is not None and idcathedra != 0:
            where += """ AND (:idcathedra=0 OR c.meta_course IN (SELECT meta_course FROM l_mcourse_cathedra WHERE idcathedra=:idcathedra) )"""
        if xp_key is not None and xp_key != 0:
            where += """ AND (:xp_key=0 OR EXISTS (SELECT 1 FROM umk_years y WHERE y.umk=u.id AND y.school_year=:xp_key))"""

        # if 'only_schedule' in args.keys():
        #     if (args['only_schedule']):
        #         where = " and c.cid in (select cid from nnz_schedule where " + str(g.user.mid) + " = any(teacher_mid))"

        sql = (
            """
            SELECT id, mp.edu_direct_id,
             concat_ws(' ',c.title, concat(' (',c.course_index,')')) as "Дисциплина", 
             f.faculty as "Факультет", 
             td.training_direct as "Направление подготовки (специальность)", 
             mp.name as "Военная специальность", 
             ed.specialization as "Специализация", 
             clm.cname as "Учебный план", 
             cat.cathedra as "Кафедра", 
             u.protocol as "Номер протокола", 
             u.approved as "Дата"
            FROM umk u 
             LEFT JOIN faculty f ON f.idfaculty = u.idfaculty 
             LEFT JOIN cathedras cat ON cat.idcathedra = u.idcathedra 
             LEFT JOIN courses c ON c.cid = u.cid 
             JOIN curriculum clm ON clm.idcurriculum = u.idcurriculum 
              JOIN qualif_demands q ON q.q_demand_id=clm.q_demand_id 
               JOIN militaryprofession mp ON mp.mpid=q.mpid
                JOIN edu_direction ed ON ed.edu_direct_id=mp.edu_direct_id 
                 JOIN training_directions td ON td.training_direct_id=ed.training_direct_id 
            WHERE 1=1
            """
            + where
            + "ORDER BY clm.cname"
        )

        stmt = text(sql)
        if cid is not None and cid != 0:
            stmt = stmt.bindparams(cid=cid)
        if idcurriculum is not None and idcurriculum != 0:
            stmt = stmt.bindparams(idcurriculum=idcurriculum)
        if meta_course is not None and meta_course != 0:
            stmt = stmt.bindparams(meta_course=meta_course)
        if idcathedra is not None and idcathedra != 0:
            stmt = stmt.bindparams(idcathedra=idcathedra)
        if xp_key is not None and xp_key != 0:
            stmt = stmt.bindparams(xp_key=xp_key)
        query = conn.execute(stmt)
        result = {"UMK": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        if len(result["UMK"]) == 0:
            return None

        return result

    def getUMKDetails(self, id):
        conn = current_app.ms.db(self.lname).connect()

        sql = """SELECT id,
	 (select array_to_string(ARRAY(SELECT
curriculum_course.id_curriculum_course
FROM curriculum_course
INNER JOIN  curriculum_detail ON curriculum_course.id_curr_detail=curriculum_detail.id_curr_detail
INNER JOIN umk ON umk.cid=curriculum_detail.cid
WHERE umk.cid=u.cid), ',')) as id_curriculum_course,
     concat_ws(' ',c.title, concat(' (',c.course_index,')')) as "Дисциплина", 
     f.faculty as "Факультет", 
     td.training_direct as "Направление подготовки (специальность)", 
     mp.name as "Военная специальность", 
     ed.specialization as "Специализация", 
	 (SELECT array_to_string(array_agg(s.name), ',')
      FROM school_year  s
      INNER JOIN umk_years uy ON uy.school_year=s.xp_key AND uy.umk=u.id) "Годы",
     '1,2' AS "Курсы",
	 '131, 124' AS "Группы",
	 u.desc_fgos "Выписка из ФГОС",
	 u.desc_qualif "Выписка из КТ",
	 u.desc_plan "Выписка из УП",
	 u.desc_program "Выписка из РП",
	 u.desc_tema "Выписка из ТП"
     FROM umk u
     LEFT JOIN faculty f ON f.idfaculty = u.idfaculty 
     LEFT JOIN cathedras cat ON cat.idcathedra = u.idcathedra 
     LEFT JOIN courses c ON c.cid = u.cid 
     JOIN curriculum clm ON clm.idcurriculum = u.idcurriculum 
     JOIN qualif_demands q ON q.q_demand_id=clm.q_demand_id 
     JOIN militaryprofession mp ON mp.mpid=q.mpid
     JOIN edu_direction ed ON ed.edu_direct_id=mp.edu_direct_id 
     JOIN training_directions td ON td.training_direct_id=ed.training_direct_id 
	 WHERE u.id = :id"""

        stmt = text(sql)
        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)
        result = {"UMK": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        if len(result["UMK"]) == 0:
            return None

        return result

    def getUMKLinks(self, id, type):
        conn = current_app.ms.db(self.lname).connect()
        sql = """SELECT *  FROM umk_links WHERE umk=:id AND umk_subtype =:type ORDER BY sorting,description"""
        stmt = text(sql)
        stmt = stmt.bindparams(id=id)
        stmt = stmt.bindparams(type=type)
        query = conn.execute(stmt)
        result = {"UMKLinks": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}
        return result

    def getUMKEduPlan(self, id):
        conn = current_app.ms.db(self.lname).connect()

        sql = """SELECT g.dis_cycle_id, g.dis_group_id, c.cid FROM courses c 
				 JOIN discipline_groups g ON g.dis_group_id=c.dis_group_id 
				 JOIN umk ON umk.cid=c.cid 
		         WHERE umk.id=:id"""
        stmt = text(sql)
        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)

        for row in query:
            idCycle = row.dis_cycle_id
            idGroup = row.dis_group_id
            idPredmet = row.cid

        sql = """select xp_fill_curriculum_new((select idcurriculum from umk where id=:id));
		DELETE FROM tmp_plan WHERE NOT (
        (dis_cycle_id=:idCycle AND dis_group_id=0 AND cid=0) OR 
        (dis_cycle_id=:idCycle AND dis_group_id=:idGroup AND cid=0) OR 
        (dis_cycle_id=:idCycle AND dis_group_id=:idGroup AND cid=:idPredmet));
		select  
		idx, discipline,  labour_intensity, hrs, 
		cast(with_lecturer as text) with_lecturer, 
		cast(lecturing as text) lecturing, 
		cast(seminar as text) seminar, 	
		cast(laboratory_works as text) laboratory_works, 			 
		cast(practical_training as text) practical_training,				 		
		cast(group_exercises as text) group_exercises,
		cast(group_classes as text) group_classes,
		cast(tactical_exercises as text) tactical_exercises,
		cast(war_games as text) war_games,		 
		cast(control_work as text) control_work,		 		 
		cast(course_work as text) course_work,		 		 		 
		cast(ind_with_lecturer as text) ind_with_lecturer,
		cast(test as text) test,		 
		cast(independent_work as text) independent_work,		 		 
		cast(i1 as text) i1, cast(s1 as text) s1,
		cast(i2 as text) i2, cast(s2 as text) s2,
		cast(i3 as text) i3, cast(s3 as text) s3,
		cast(i4 as text) i4, cast(s4 as text) s4,
		cast(i5 as text) i5, cast(s5 as text) s5,		 
		cast(i6 as text) i6, cast(s6 as text) s6,
		cast(i7 as text) i7, cast(s7 as text) s7,
		cast(i8 as text) i8, cast(s8 as text) s8,
		cast(i9 as text) i9, cast(s9 as text) s9,
		cast(i10 as text) i10, cast(s10 as text) s10,		 
		fin_exam_str, fin_test_str, fin_test_with_grade_str, fin_test_work_str
		from tmp_plan;"""
        stmt = text(sql)
        stmt = stmt.bindparams(id=id)
        stmt = stmt.bindparams(idCycle=idCycle)
        stmt = stmt.bindparams(idGroup=idGroup)
        stmt = stmt.bindparams(idPredmet=idPredmet)

        query = conn.execute(stmt)
        result = {
            "UMKEduPlan": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        }

        return result

    def getUMKWorkProgram(self, id):
        conn = current_app.ms.db(self.lname).connect()
        sql = """select id_curriculum_course,  cc.id_curr_detail  
		from curriculum_course cc 
		join curriculum_detail cd ON cd.id_curr_detail = cc.id_curr_detail 
		join umk ON umk.idcurriculum = cd.idcurriculum and umk.cid = cd.cid 
		where umk.id = :id"""
        stmt = text(sql)
        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)

        for row in query:
            idProgram = row.id_curriculum_course
            id_curr_detail = row.id_curr_detail

        sql = """select tl.tlid, tl.eyid, tl.name, 
		 cast(coalesce(stt.trim_time,round(sti.trim_time*c.intensity_unit_hrs)) as text) trim_time,   
		 cast(ccd.test as text) test, cast(ccd.independent_work as text) independent_work, ccd.files 
		from termslist tl 
		  join study_by_terms stt on stt.tlid = tl.tlid and tl.eyid = stt.eyid and stt.tt_type IN ('t') 
			and stt.id_curr_detail =  :id_curr_detail
		  join study_by_terms sti on sti.tlid = tl.tlid and tl.eyid = sti.eyid and sti.tt_type IN ('i') 
			and sti.id_curr_detail =  :id_curr_detail
		   JOIN curriculum_detail cd ON cd.id_curr_detail= coalesce(stt.id_curr_detail,sti.id_curr_detail) 
			 JOIN curriculum c ON c.idcurriculum= cd.idcurriculum 
		  left outer join curriculum_course_details ccd on  1=1 
			and ccd.tlid = tl.tlid 
			and ccd.eyid = tl.eyid 
			and ccd.id_curriculum_course =  :id_curr_detail
			and ccd.oid is null   
		where 
		  coalesce(stt.trim_time,sti.trim_time) > 0 
		order by tl.sorting """
        stmt = text(sql)
        stmt = stmt.bindparams(id_curr_detail=id_curr_detail)
        query = conn.execute(stmt)

        UMKWorkProgram = {}

        for row in query:
            UMKWorkProgram[str(row.tlid)] = dict(zip(tuple(query.keys()), row))
            sql = """ select ccd.oid,  ccd.tlid, ccd.eyid, ccd.files, 
				  cast(ccd.lecturing as text) lecturing, cast(ccd.seminar as text) seminar , cast(ccd.laboratory_works as text) laboratory_works, cast(ccd.practical_training as text) practical_training, 
				  cast(ccd.group_exercises as text)group_exercises , cast(ccd.group_classes as text) group_classes, cast(ccd.tactical_exercises as text) tactical_exercises, cast(ccd.war_games as text) war_games, 
				  cast(ccd.control_work as text) control_work,
				  cast(ccd.course_work as text) course_work, cast(ccd.ind_with_lecturer as text) ind_with_lecturer, 
				  o.title, o.title_index 
				from curriculum_course_details ccd 
				  inner join curriculum_course cc on cc.id_curriculum_course = ccd.id_curriculum_course 
				  inner join organizations o on o.oid = ccd.oid 
				where ccd.oid is not null and ccd.tlid = :tlid
					and exists( select 1 from study_by_terms st where st.tlid = ccd.tlid and st.eyid = ccd.eyid and st.tt_type IN ('t','i') and st.id_curr_detail = :id_curr_detail
					and ccd.id_curriculum_course =:idProgram)
				order by ccd."order" desc"""
            subjects_stmt = text(sql)
            subjects_stmt = subjects_stmt.bindparams(tlid=row.tlid)
            subjects_stmt = subjects_stmt.bindparams(idProgram=idProgram)
            subjects_stmt = subjects_stmt.bindparams(id_curr_detail=id_curr_detail)
            subjects_query = conn.execute(subjects_stmt)
            UMKWorkProgram[str(row.tlid)]["subjects"] = []
            for subjects_row in subjects_query:
                subject = dict(zip(tuple(subjects_query.keys()), subjects_row))
                UMKWorkProgram[str(row.tlid)]["subjects"].append(subject)

        return UMKWorkProgram

    def getUMKTemaPlan(self, id):
        conn = current_app.ms.db(self.lname).connect()
        sql = """select min(ct.id) id 
				from course_tema_plan ct 
				join curriculum_course cc ON cc.id_curriculum_course=ct.id_curriculum_course 
				join curriculum_detail cd ON cd.id_curr_detail=cc.id_curr_detail 
				join umk ON umk.idcurriculum = cd.idcurriculum and umk.cid = cd.cid 
				where umk.id = :id"""
        stmt = text(sql)
        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)

        for row in query:
            idTema = row.id

        sql = """select tl.tlid, tl.name,case st.tt_type  WHEN 't'  THEN cast(st.trim_time  as text) WHEN 'i' THEN cast((st.trim_time * clm.intensity_unit_hrs) as text) end trim_time, cast(SUM(ccd.test) as text) as test 
      from termslist tl 
        join study_by_terms st on st.tlid = tl.tlid and tl.eyid = st.eyid and st.tt_type IN ('t','i') 
         JOIN curriculum_detail cd ON cd.id_curr_detail= st.id_curr_detail 
          JOIN curriculum clm ON clm.idcurriculum=cd.idcurriculum 
       JOIN curriculum_course cc ON cc.id_curr_detail = cd.id_curr_detail 
        LEFT JOIN curriculum_course_details ccd ON ccd.id_curriculum_course = cc.id_curriculum_course AND ccd.tlid=tl.tlid AND ccd.oid<0 
      where 
       cc.id_curriculum_course = (select id_curriculum_course from course_tema_plan where id = :idTema)
       and (st.trim_time) > 0 
      GROUP BY tl.tlid,tl.name, tl.sorting, st.trim_time, st.tt_type, clm.intensity_unit_hrs 
      order by tl.sorting"""

        stmt = text(sql)
        stmt = stmt.bindparams(idTema=idTema)
        query = conn.execute(stmt)
        UMKTemaPlan = {}

        for row in query:
            UMKTemaPlan[str(row.tlid)] = dict(zip(tuple(query.keys()), row))

            sql = """  SELECT ccd.id_curriculum_course_details, CONCAT_WS(' ', MAX(o.title_index), MAX(o.title)) as tema ,  
		   cast(SUM(IFNULL(ccdh.hours, 0)) as text) as hours,  ccd."order" 
		   FROM curriculum_course_details ccd 
		   JOIN organizations o ON o.oid = ccd.oid 
           LEFT OUTER JOIN curriculum_course_detail_hours ccdh ON ccdh.id_curriculum_course_details = ccd.id_curriculum_course_details  and ccdh.hours > 0
		   WHERE ccd.tlid=:tlid AND ccd.id_curriculum_course=(select id_curriculum_course from course_tema_plan where id = :idTema)
		   GROUP BY ccd.id_curriculum_course_details
           ORDER BY ccd."order" """
            subjects_stmt = text(sql)
            subjects_stmt = subjects_stmt.bindparams(idTema=idTema)
            subjects_stmt = subjects_stmt.bindparams(tlid=row.tlid)
            subjects_query = conn.execute(subjects_stmt)

            UMKTemaPlan[str(row.tlid)]["subjects"] = []

            for subjects_row in subjects_query:
                subject = dict(zip(tuple(subjects_query.keys()), subjects_row))
                UMKTemaPlan[str(row.tlid)]["subjects"].append(subject)

                sql = """SELECT t.id, t.num, t.tema, cast(t.hours as text) hours, cast(t.homework as text) homework , cast(t.hw_hours as text) hw_hours, et.typeid as lesson_type,  
					et.typename as Lesson_type_desc, 
					t.num  
                    FROM course_tema_detail t 
                    LEFT OUTER JOIN eventtools et ON et.typeid = t.eventtool
					WHERE t.id_curriculum_course_details = :id_curriculum_course_details 
					ORDER BY  t.num"""

                details_stmt = text(sql)
                details_stmt = details_stmt.bindparams(
                    id_curriculum_course_details=subjects_row.id_curriculum_course_details
                )
                details_query = conn.execute(details_stmt)
                # for details_row in details_query:
                subject["details"] = [
                    dict(zip(tuple(details_query.keys()), i))
                    for i in details_query.cursor
                ]

        return UMKTemaPlan

    def getUMKtheme(self, cid, idcurriculum, mid, is_admin):
        conn = current_app.ms.db(self.lname).connect()
        where = " AND people.mid = :mid "
        is_admin_join = (
            " JOIN teachers t ON t.cid = cd.cid JOIN people ON people.mid = t.mid "
        )

        if is_admin != "Нет":
            where = " "
            is_admin_join = " "
        # if 'only_schedule' in args.keys():
        #     if (args['only_schedule']):
        #         where = " and c.cid in (select cid from nnz_schedule where " + str(g.user.mid) + " = any(teacher_mid))"

        sql = (
            """
            SELECT p.id, 
  p.name::character varying as "Тематические планы", 
  string_agg(c.cname::character varying,',') as "Учебный план", 
  concat_ws(' ',crs.course_index,crs.title)::character varying(255) as "Дисциплина", 
  cc.id_curriculum_course,
  case p.status 
    when 0 then 'Утвержден' 
    when 1 then 'Действующий' 
    when 2 then 'Закрыт' 
    when 3 then 'Проект' 
  end::character varying(100) as "Статус" FROM course_tema_plan p
JOIN curriculum_course cc ON cc.id_curriculum_course = p.id_curriculum_course 
JOIN curriculum_detail cd ON cd.id_curr_detail = any(cc.id_curr_details || cc.id_curr_detail) AND cd.cid=p.cid 
JOIN curriculum c ON c.idcurriculum = cd.idcurriculum 
JOIN courses crs ON crs.cid = cd.cid 
  --AND (crs.meta_course = 0 OR 0=0) --Дисциплина
  --AND ( 39=0 OR 39 IN (SELECT sy2c.syid FROM StudyYears2curriculum sy2c WHERE sy2c.idcurriculum = cd.idcurriculum) ) --учебный год
 """
            + is_admin_join
            + """WHERE (cd.idcurriculum=:idcurriculum OR :idcurriculum=0)  AND (cd.cid=:cid OR :cid=0) """
            + where
            + "group by p.id, p.name, crs.cid,crs.course_index,crs.title, p.status, cc.id_curriculum_course"
        )

        stmt = text(sql)
        stmt = stmt.bindparams(cid=cid)
        stmt = stmt.bindparams(idcurriculum=idcurriculum)
        if is_admin == "Нет":
            stmt = stmt.bindparams(mid=mid)
        query = conn.execute(stmt)
        result = {"UMK": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        if len(result["UMK"]) == 0:
            return None

        return result

    def get_theme_plan(self, cid, idcurriculum):
        conn = current_app.ms.db(self.lname).connect()
        where = " 1 = 1"
        if cid != 0:
            where += " AND ct.cid = :cid"
        if idcurriculum != 0:
            where += " AND cd.idcurriculum = :idcurriculum"
        sql = """select ct.* id 
    				from course_tema_plan ct 
                join curriculum_course cc ON cc.id_curriculum_course=ct.id_curriculum_course 
                join curriculum_detail cd ON cd.id_curr_detail=cc.id_curr_detail 
                join umk ON umk.idcurriculum = cd.idcurriculum and umk.cid = cd.cid 
                where {where}""".format(
            where=where
        )
        stmt = text(sql)
        if cid != 0:
            stmt = stmt.bindparams(cid=cid)
        if idcurriculum != 0:
            stmt = stmt.bindparams(idcurriculum=idcurriculum)
        query = conn.execute(stmt)

        result = {
            "theme_plan": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        }

        if len(result["theme_plan"]) == 0:
            return None

        return result

    def newUmkThemePlan(self, umk_id, id_curriculum_course):
        conn = current_app.ms.db(self.lname).connect()

        result_dict = {}

        sql = """
        SELECT 
            vc.tlid,
            tl.name, 
            tl.number::integer, 
            vc.term_hours+COALESCE(
                (
                    SELECT SUM(interm_test) 
                    FROM curriculum_course_details 
                    WHERE tlid=vc.tlid 
                        AND id_curriculum_course=cc.id_curriculum_course
                        AND oid<0
                ),0
            ) AS trim_time, 
            COALESCE(
                (
                    SELECT SUM(t.hw_hours)   
                    FROM curriculum_course_details ccd 
                    JOIN course_tema_detail t ON t.id_curriculum_course_details = ccd.id_curriculum_course_details   
                    WHERE ccd.id_curriculum_course = cc.id_curriculum_course 
                        AND ccd.tlid = vc.tlid 
                        AND t.course_tema_plan=:umk_id
                ), 0
            ) AS hw_hours,  -- umk_id - id тем плана
            ccd.independent_work AS hw_hours_req 
        FROM curriculum_course cc  
        JOIN (
                SELECT tlid,id_curriculum_course, SUM(ccdh.hours) AS term_hours 
                FROM curriculum_course_details ccd   
                LEFT JOIN curriculum_course_detail_hours ccdh ON ccdh.id_curriculum_course_details=ccd.id_curriculum_course_details AND ccdh.hours>0   
                GROUP BY tlid,id_curriculum_course  
            )  vc ON vc.id_curriculum_course=cc.id_curriculum_course    
        JOIN termslist tl ON tl.tlid=vc.tlid AND (tl.tlid=0 OR 0=0)  
        LEFT JOIN  curriculum_course_details ccd ON ccd.id_curriculum_course=cc.id_curriculum_course AND ccd.tlid=tl.tlid AND ccd.oid IS NULL 
        WHERE cc.id_curriculum_course = :id_curriculum_course      -- id_curriculum_course - id_curriculum_course из записи тем плана
        AND vc.term_hours>0  
        ORDER BY tl.number::integer;
        """
        stmt = text(sql)
        stmt = stmt.bindparams(umk_id=umk_id)
        stmt = stmt.bindparams(id_curriculum_course=id_curriculum_course)
        query = conn.execute(stmt)

        first_query_rows = self.create_list_of_rows(query)
        for row in first_query_rows:
            result_dict[row.get("tlid")] = row

            sql = """
                SELECT
                    ccd.id_curriculum_course_details,
                    CONCAT_WS(' ', o.title_index, o.title) as tema,
                    o.oid, o.level,
                    COALESCE(
                        (
                            SELECT SUM(hours)
                            FROM curriculum_course_detail_hours ccdh
                            WHERE ccdh.id_curriculum_course_details = ccd.id_curriculum_course_details
                        ),
                        COALESCE(ccd.lecturing,0)+
                        COALESCE(ccd.seminar,0)+
                        COALESCE(ccd.laboratory_works,0)+
                        COALESCE(ccd.practical_training,0)+
                        COALESCE(ccd.group_exercises,0)+
                        COALESCE(ccd.group_classes,0)+
                        COALESCE(ccd.tactical_exercises,0)+
                        COALESCE(ccd.war_games,0)+
                        COALESCE(ccd.course_work,0)+
                        COALESCE(ccd.control_work,0)
                    ) hours,  
                    ccd."order", 
                    COALESCE(
                        (
                            SELECT SUM(t.hw_hours) 
                            FROM course_tema_detail t 
                            WHERE t.id_curriculum_course_details = ccd.id_curriculum_course_details AND t.course_tema_plan=:umk_id
                        ), 0
                    ) AS hw_hours,  --62 - id тем плана
                    ccd.independent_work as hw_scheduled 
                FROM curriculum_course_details ccd 
                JOIN organizations o ON o.oid = ccd.oid 
                WHERE ccd.tlid=:tlid -- tlid из первого запроса
                    AND ccd.id_curriculum_course=:id_curriculum_course --358 -    id_curriculum_course из записи тем плана 
                ORDER BY ccd."order";
            """
            stmt = text(sql)
            stmt = stmt.bindparams(umk_id=umk_id)
            stmt = stmt.bindparams(tlid=row["tlid"])
            stmt = stmt.bindparams(id_curriculum_course=id_curriculum_course)
            query = conn.execute(stmt)
            second_query_rows = self.create_list_of_rows(query)
            result_dict[row.get("tlid")]["subjects"] = []

            for second_row in second_query_rows:
                sql = """
                    SELECT
                      t.id, t.num, t.tema, t.hours,
                      -- t.homework as homework, 
                      t.hw_hours , t.eventtool as lesson_type,
                      coalesce(nullif(cs."ShortName",''),cs.cathedra) as cathedra,
                      e.typename as Lesson_type_desc, t.num
                    FROM course_tema_detail t
                    JOIN curriculum_course_details ccd ON ccd.id_curriculum_course_details=t.id_curriculum_course_details
                    JOIN curriculum_course cc ON cc.id_curriculum_course=ccd.id_curriculum_course
                    LEFT JOIN eventtools e ON e.typeid   = t.eventtool
                    LEFT JOIN cathedras cs ON cs.idcathedra=t.cid
                    WHERE t.course_tema_plan=:umk_id
                      AND t.id_curriculum_course_details=:id_curriculum_course_details
                      and ccd.oid>0 ORDER BY t.num;
                """
                stmt = text(sql)
                stmt = stmt.bindparams(umk_id=umk_id)
                stmt = stmt.bindparams(
                    id_curriculum_course_details=second_row[
                        "id_curriculum_course_details"
                    ]
                )
                query = conn.execute(stmt)
                third_query_rows = self.create_list_of_rows(query)

                second_row["details"] = []
                if len(third_query_rows) > 0:
                    second_row["details"] = third_query_rows


                result_dict[row.get("tlid")]["subjects"].append(second_row)

            exams_sql = """
                SELECT 
                  ccd.id_curriculum_course_details, 
                  ctd.id, 
                  COALESCE(ctd.lesson_type,ee.eeid,0) as lesson_type, 
                  ee.typename as tema,  
                  IFNULL(ccd.interm_test,0) as hours, 
                  IFNULL(ccd.independent_work,0) as hw_hours,  
                  IFNULL(ccd.test,0) as test, 
                  ccd.order,  
                  IFNULL(ctd.hours,0) as s_hours, 
                  IFNULL(ctd.in_session,0) in_session    
                FROM curriculum_course_details ccd    
                JOIN eventtools_exams ee      ON ee.eeid = ccd.oid    
                LEFT JOIN course_tema_detail ctd      ON ctd.id_curriculum_course_details = ccd.id_curriculum_course_details   
                WHERE ccd.tlid = :tlid  -- tlid из первого запроса   
                  and ccd.id_curriculum_course = :id_curriculum_course -- 358 -    id_curriculum_course из записи тем плана    
                  and ccd.oid < 0 ;
            """
            stmt = text(exams_sql)
            stmt = stmt.bindparams(tlid=row["tlid"])
            stmt = stmt.bindparams(id_curriculum_course=id_curriculum_course)
            query = conn.execute(stmt)
            exams_query_rows = self.create_list_of_rows(query)
            result_dict[row.get("tlid")]["exams"] = exams_query_rows

        return result_dict

    @staticmethod
    def create_list_of_rows(query):
        result = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        for item in result:
            for key in item:
                if isinstance(item[key], Decimal):
                    item[key] = float(item[key])
        return result

    def get_umk_links_by_idcurriculum_cid(
        self, idcurriculum, cid, part, umk_subtype, link_type
    ):
        conn = current_app.ms.db(self.lname).connect()

        # Определяем есть ли подгруппа по дисциплине с тем. планом
        stmt = text("""
        SELECT gn.course_tema_plan
        FROM groupuser gu
        JOIN groupname gn ON gn.gid = gu.gid
        WHERE gu.mid = :mid AND gu.cid = :cid
        """)

        params = {'mid': g.user.mid, 'cid': cid}
        id_plan_result = conn.execute(stmt, params).fetchone()
        if id_plan_result:
            id_plan = id_plan_result.course_tema_plan

            if id_plan:
                # Если подгруппа с ТП есть, то получаем id РПД
                stmt = text("""
                SELECT 
                    IF(mr.mrid IS NOT Null, mr.mrid, l.id) AS id, 
                    l.umk, 
                    l.umk_subtype, 
                    l.link, 
                    l.link_type, 
                    l.description,
                    mr.mr_isfile
                FROM curriculum_course_books cb
                JOIN umk_links l ON l.id=cb.bookid
                JOIN course_tema_plan tp ON tp.id = :id_plan AND tp.id_curriculum_course = cb.id_curriculum_course
                LEFT JOIN methodical_room mr ON mr.mrid = l.mrid 
                WHERE cb.part=:part AND l.link_type = :link_type
                ORDER BY cb,num,l.description
                """)
                query = conn.execute(stmt, {"id_plan": id_plan, "part": part, "link_type": link_type})
                return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        else:
            stmt = text("""
                SELECT 
                    IF(mr.mrid IS NOT Null, mr.mrid, l.id) AS id,
                    l.umk,
                    l.umk_subtype,
                    l.link,
                    l.link_type,
                    l.description,
                    mr.mr_isfile
                FROM umk_links l
                JOIN umk ON umk.id = l.umk
                LEFT JOIN methodical_room mr ON mr.mrid = l.mrid
                WHERE umk.idcurriculum = :idcurriculum 
                    AND umk.cid = :cid 
                    AND l.umk_subtype = :umk_subtype 
                    AND l.link_type = :link_type
                """)
            query = conn.execute(stmt,
                                 {
                                    "idcurriculum": idcurriculum,
                                     "cid": cid,
                                     "umk_subtype": umk_subtype,
                                     "link_type": link_type
                                 })
            return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_umk_by_id(self, id):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
            SELECT ul.id, ul.umk, ul.umk_subtype, ul.link, ul.link_type
            FROM umk_links ul
            WHERE ul.id = :id
            """
        stmt = text(sql)
        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)
        result = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        return result[0]

    def get_filename_by_mrid(self, id):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
            SELECT mr_name
            FROM methodical_room
            WHERE mrid = :id
            """
        stmt = text(sql)
        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)
        result = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        return result[0]
