from itsdangerous import (
    TimedJSONWebSignatureSerializer as Serializer,
    BadSignature,
    SignatureExpired,
)
from flask import request, g, current_app
from sqlalchemy.sql import text

# import asyncio
import hashlib
import sys
import pickle


class Count:
    def __init__(self):
        self.count = 0

    def serialize(self):
        return {"count": self.count}


class User:
    def __init__(self, cname, access_modes=None):
        self.id = ""
        self.gid = 0
        self.password_hash = ""
        self.lname = cname
        self.need_change_password = 0
        self.photosize = 0
        self.contact = ""
        self.email = ""
        self.employername = ""
        self.birthday = ""
        self.rfid = ""
        self.access_modes = access_modes

    def get_users(self):
        conn = current_app.ms.db(self.lname).connect()

        sql = """select * from people"""

        stmt = text(sql)
        query = conn.execute(stmt)
        userDetails = {
            "users": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        }
        return userDetails

    def get_user_from_db(self, username):
        user = self.get_user_from_redis(username)
        lname = self.lname
        if user is not None:
            self = user
            self.lname = lname
            return self
        self = self.get_user_from_sql(username)
        if self is not None:
            self.lname = lname
            self.set_user_to_redis()
        return self

    def get_user_from_redis(self, username):
        cachedUser = current_app.ms.redis(self.lname).get(username)

        if cachedUser is not None:
            self = pickle.loads(cachedUser)
            return self
        return

    def set_user_to_redis(self):
        current_app.ms.redis(self.lname).setex(self.id, 60, pickle.dumps(self))
        return

    def check_actual_user(self, mid):
        conn = current_app.ms.db(self.lname).connect()
        stmt = text(
            """
            SELECT
                CASE
                    WHEN COALESCE(st."Type", '') NOT IN ('Выпуск', 'Отчисление', 'Поступление', 'Архивная запись')
                         OR pf.workstatus NOT IN ('Уволен')
                    THEN 1
                    ELSE 0
                END AS is_eligible
            FROM people p
            LEFT JOIN xp_status st ON st.xp_key = (
                SELECT xs.xp_key
                FROM groupuser_transfer gt
                JOIN xp_status xs ON gt.xp_status = xs.xp_key
                WHERE gt.mid = p.mid
                ORDER BY gt.xp_date DESC, gt.xp_status
                LIMIT 1
            )
            JOIN xp_personal_file pf on p.mid = pf.mid
            WHERE p.mid = :mid;
            """
        )
        stmt = stmt.bindparams(mid=mid)
        query = conn.execute(stmt)
        return query.fetchone().is_eligible

    def user_is_teachermid(self, userid):
        conn = current_app.ms.db(self.lname).connect()
        stmt = text("select count(mid) as numroles from teachers where mid=:id")
        stmt = stmt.bindparams(id=userid)

        query = conn.execute(stmt)
        roles = 0
        for row in query:
            roles = row.numroles

        if roles == 0:
            return False

        return True

    def user_is_rasdel_admin(self, userid, rasdel):
        conn = current_app.ms.db(self.lname).connect()
        sql = """SELECT
   CASE MAX(FIND_IN_SET(xp_access.value, 'Нет,Чтение,Полный'))
	 WHEN 2 THEN 'Чтение'
	 WHEN 3 THEN 'Полный'
	 ELSE 'Нет'
   END "value"
 FROM xp_access
 INNER JOIN xp_access_rasdel ON xp_access_rasdel.xp_Key = xp_access.Rasdel
 INNER JOIN xp_access_rasdel parent ON xp_access_rasdel.parent = parent.xp_Key
   AND parent.parent = 0 AND parent.xp_Key <> 21
 INNER JOIN permission2mid ON xp_access.Role = permission2mid.pmid AND permission2mid.mid = :userid
 WHERE cast(xp_access_rasdel.Name as varchar(200)) = :rasdel"""
        stmt = text(sql)
        stmt = stmt.bindparams(userid=userid)
        stmt = stmt.bindparams(rasdel=rasdel)

        query = conn.execute(stmt)
        isAdmin = False
        for row in query:
            isAdmin = row.value == "Полный"

        return isAdmin

    def user_is_teacherid(self, userid):
        conn = current_app.ms.db(self.lname).connect()
        stmt = text(
            "select count(t.mid) as numroles from teachers t join people p on t.mid=p.mid where login=:id"
        )
        stmt = stmt.bindparams(id=userid)

        query = conn.execute(stmt)
        roles = 0
        for row in query:
            roles = row.numroles

        if roles == 0:
            return False

        return True

    @staticmethod
    def check_permission(lname: str, mid: int, rasdel: str, rasdel_parent: str) -> int:
        sql = """
        SELECT
                COALESCE(MAX(value),0) as value

        FROM (
            SELECT
                    case lower(a.value)
                        when 'нет' then 0
                        when 'чтение' then 1
                        when 'полный' then 2
                        else 0 
                    end as value

            FROM xp_access a
            JOIN xp_access_rasdel r ON r.xp_key=a.rasdel
            JOIN xp_access_rasdel p ON p.xp_key=r.parent
            JOIN permission_groups g on g.pmid=a.role
            JOIN permission2mid p2m ON p2m.pmid=g.pmid
            WHERE r.name='{rasdel}' and p.name='{rasdel_parent}'
            and p2m.mid={mid}
        ) t
        """.format(
            mid=mid, rasdel=rasdel, rasdel_parent=rasdel_parent
        )
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        result = query.first()
        return result.value

    def get_user_from_sql(self, username):
        # Connect to databse
        # e = create_engine(current_app.config['SQLALCHEMY_DATABASE_URI'], pool_recycle=3600)
        conn = current_app.ms.db(self.lname).connect()
        # Perform query and return JSON data
        # print("DBQ", file=sys.stderr)
        stmt = text(
            "select mid,login,password,lastname,firstname,patronymic,need_change_password from people where lower(login) = lower(:u)"
        )
        stmt = stmt.bindparams(u=username)
        # "select login,password from people where login='"+username+"'"
        query = conn.execute(stmt)
        for row in query:
            u = User("")
            u.mid = row.mid
            u.id = row.login
            u.lastname = row.lastname
            u.firstname = row.firstname
            u.patronymic = row.patronymic
            u.password_hash = row.password
            u.need_change_password = row.need_change_password

        u.isTeacher = self.user_is_teachermid(u.mid)
        u.isJournalAdmin = self.user_is_rasdel_admin(
            u.mid, "Классный журнал.Администратор"
        )
        return u

    def prepare_logger(self, conn):
        sql = """drop table if exists LocalInfo;
             create temporary table LocalInfo (HostName varchar(100), HostIP varchar(100), UserLogin varchar(100),
                MacAddress varchar(100));
             insert into LocalInfo (HostName, HostIP, UserLogin, MacAddress) values (:host,:ip,:login,:macaddress)"""

        if request.environ.get("HTTP_X_FORWARDED_FOR") is None:
            ip = request.environ["REMOTE_ADDR"]
        else:
            ip = request.environ["HTTP_X_FORWARDED_FOR"]

        host = "WEB"
        login = g.user.id

        stmt = text(sql)
        stmt = stmt.bindparams(host=host)
        stmt = stmt.bindparams(ip=ip)
        stmt = stmt.bindparams(login=login)
        stmt = stmt.bindparams(macaddress=host)

        conn.execute(stmt)

    def set_user_portfolio(self, userid, portfolio):
        current_app.logger.debug(portfolio)
        sql = """UPDATE xp_personal_file 
        SET portfolio_description=:portfolio_description,portfolio_character=:portfolio_character,portfolio_interest=:portfolio_interest,
        portfolio_health=:portfolio_health,portfolio_limitations=:portfolio_limitations, portfolio_worth=:portfolio_worth 
        WHERE mid=:u"""
        sql_preveducation = """INSERT INTO portfolio_preveducation (periods, instutution, major, mid)
        VALUES (:periods, :instutution, :major, (select mid from xp_personal_file where mid=:userid))
        ON CONFLICT (id) DO UPDATE SET
        periods=:periods, instutution=:instutution, major=:major
        WHERE portfolio_preveducation.id in (select id from portfolio_preveducation where mid=:userid);
        DELETE from portfolio_preveducation where id not in (select min(id) from portfolio_preveducation group by periods, instutution, major);"""
        sql_del_preveducation = "DELETE FROM portfolio_preveducation WHERE mid=:userid;"
        sql_sociallife = """INSERT INTO portfolio_sociallife (name, participation, results, mid)
        VALUES (:name, :participation, :results, (select mid from xp_personal_file where mid=:userid))
        ON CONFLICT (id) DO UPDATE SET
        name=:name, participation=:participation, results=:results
        WHERE portfolio_sociallife.id in (select id from portfolio_sociallife where mid=:userid);
        DELETE from portfolio_sociallife where id not in (select min(id) from portfolio_sociallife group by name, participation, results);"""
        sql_del_sociallife = "DELETE FROM portfolio_sociallife WHERE mid=:userid;"
        sql_scientific = """INSERT INTO portfolio_scientific (name, participation, results, mid)
        VALUES (:name, :participation, :results, (select mid from xp_personal_file where mid=:userid))
        ON CONFLICT (id) DO UPDATE SET
        name=:name, participation=:participation, results=:results
        WHERE portfolio_scientific.id in (select id from portfolio_scientific where mid=:userid);
        DELETE from portfolio_scientific where id not in (select min(id) from portfolio_scientific group by name, participation, results);"""
        sql_del_scientific = "DELETE FROM portfolio_scientific WHERE mid=:userid;"
        sql_sport = """INSERT INTO portfolio_sport (name, participation, results, mid)
        VALUES (:name, :participation, :results, (select mid from xp_personal_file where mid=:userid))
        ON CONFLICT (id) DO UPDATE SET
        name=:name, participation=:participation, results=:results
        WHERE portfolio_sport.id in (select id from portfolio_sport where mid=:userid);
        DELETE from portfolio_sport where id not in (select min(id) from portfolio_sport group by name, participation, results);"""
        sql_del_sport = "DELETE FROM portfolio_sport WHERE mid=:userid;"
        conn = current_app.ms.db(self.lname).connect()

        self.prepare_logger(conn)

        stmt = text(sql)
        stmt = stmt.bindparams(u=userid)
        stmt = stmt.bindparams(portfolio_description=portfolio["portfolio_description"])
        stmt = stmt.bindparams(portfolio_character=portfolio["portfolio_character"])
        stmt = stmt.bindparams(portfolio_interest=portfolio["portfolio_interest"])
        stmt = stmt.bindparams(portfolio_health=portfolio["portfolio_health"])
        stmt = stmt.bindparams(portfolio_limitations=portfolio["portfolio_limitations"])
        stmt = stmt.bindparams(portfolio_worth=portfolio["portfolio_worth"])

        stmt_preveducation = text(sql_preveducation)
        stmt_preveducation = stmt_preveducation.bindparams(userid=userid)

        stmt_del_preveducation = text(sql_del_preveducation)
        stmt_del_preveducation = stmt_del_preveducation.bindparams(userid=userid)

        stmt_sociallife = text(sql_sociallife)
        stmt_sociallife = stmt_sociallife.bindparams(userid=userid)

        stmt_del_sociallife = text(sql_del_sociallife)
        stmt_del_sociallife = stmt_del_sociallife.bindparams(userid=userid)

        stmt_scientific = text(sql_scientific)
        stmt_scientific = stmt_scientific.bindparams(userid=userid)

        stmt_del_scientific = text(sql_del_scientific)
        stmt_del_scientific = stmt_del_scientific.bindparams(userid=userid)

        stmt_sport = text(sql_sport)
        stmt_sport = stmt_sport.bindparams(userid=userid)

        stmt_del_sport = text(sql_del_sport)
        stmt_del_sport = stmt_del_sport.bindparams(userid=userid)

        lst_portfolio_preveducation = portfolio.get("portfolio_preveducation")
        lst_portfolio_sociallife = portfolio.get("portfolio_sociallife")
        lst_portfolio_scientific = portfolio.get("portfolio_scientific")
        lst_portfolio_sport = portfolio.get("portfolio_sport")

        if (
                len(lst_portfolio_sport) == 0
                and len(lst_portfolio_scientific) == 0
                and len(lst_portfolio_sociallife) == 0
                and len(lst_portfolio_preveducation) == 0
        ):
            query = conn.execute(stmt_del_sport)
            query = conn.execute(stmt_del_scientific)
            query = conn.execute(stmt_del_sociallife)
            query = conn.execute(stmt_del_preveducation)
            query = conn.execute(stmt)

        elif (
                len(lst_portfolio_sport) == 0
                and len(lst_portfolio_scientific) == 0
                and len(lst_portfolio_sociallife) == 0
        ):
            query = conn.execute(stmt_del_preveducation)
            query = conn.execute(stmt_del_scientific)
            query = conn.execute(stmt_del_sport)
            query = conn.execute(stmt)
            query = conn.execute(stmt_preveducation, lst_portfolio_preveducation)

        elif (
                len(lst_portfolio_sport) == 0
                and len(lst_portfolio_scientific) == 0
                and len(lst_portfolio_preveducation) == 0
        ):
            query = conn.execute(stmt_del_preveducation)
            query = conn.execute(stmt_del_scientific)
            query = conn.execute(stmt_del_sport)
            query = conn.execute(stmt)
            query = conn.execute(stmt_sociallife, lst_portfolio_sociallife)

        elif (
                len(lst_portfolio_sport) == 0
                and len(lst_portfolio_sociallife) == 0
                and len(lst_portfolio_preveducation) == 0
        ):
            query = conn.execute(stmt_del_sociallife)
            query = conn.execute(stmt_del_preveducation)
            query = conn.execute(stmt_del_sport)
            query = conn.execute(stmt)
            query = conn.execute(stmt_scientific, lst_portfolio_scientific)

        elif (
                len(lst_portfolio_scientific) == 0
                and len(lst_portfolio_sociallife) == 0
                and len(lst_portfolio_preveducation) == 0
        ):
            query = conn.execute(stmt_del_sociallife)
            query = conn.execute(stmt_del_preveducation)
            query = conn.execute(stmt_del_scientific)
            query = conn.execute(stmt)
            query = conn.execute(stmt_sport, lst_portfolio_sport)

        elif len(lst_portfolio_sport) == 0 and len(lst_portfolio_scientific) == 0:
            query = conn.execute(stmt_del_sport)
            query = conn.execute(stmt_del_scientific)
            query = conn.execute(stmt)
            query = conn.execute(stmt_preveducation, lst_portfolio_preveducation)
            query = conn.execute(stmt_sociallife, lst_portfolio_sociallife)

        elif len(lst_portfolio_sport) == 0 and len(lst_portfolio_sociallife) == 0:
            query = conn.execute(stmt_del_sport)
            query = conn.execute(stmt_del_sociallife)
            query = conn.execute(stmt)
            query = conn.execute(stmt_preveducation, lst_portfolio_preveducation)
            query = conn.execute(stmt_scientific, lst_portfolio_scientific)

        elif len(lst_portfolio_scientific) == 0 and len(lst_portfolio_sociallife) == 0:
            query = conn.execute(stmt_del_scientific)
            query = conn.execute(stmt_del_sociallife)
            query = conn.execute(stmt)
            query = conn.execute(stmt_preveducation, lst_portfolio_preveducation)
            query = conn.execute(stmt_sport, lst_portfolio_sport)

        elif len(lst_portfolio_preveducation) == 0 and len(lst_portfolio_sport) == 0:
            query = conn.execute(stmt_del_preveducation)
            query = conn.execute(stmt_del_sport)
            query = conn.execute(stmt)
            query = conn.execute(stmt_sociallife, lst_portfolio_sociallife)
            query = conn.execute(stmt_scientific, lst_portfolio_scientific)

        elif (
                len(lst_portfolio_preveducation) == 0 and len(lst_portfolio_scientific) == 0
        ):
            query = conn.execute(stmt_del_preveducation)
            query = conn.execute(stmt_del_scientific)
            query = conn.execute(stmt)
            query = conn.execute(stmt_sociallife, lst_portfolio_sociallife)
            query = conn.execute(stmt_sport, lst_portfolio_sport)

        elif (
                len(lst_portfolio_preveducation) == 0 and len(lst_portfolio_sociallife) == 0
        ):
            query = conn.execute(stmt_del_preveducation)
            query = conn.execute(stmt_del_sociallife)
            query = conn.execute(stmt)
            query = conn.execute(stmt_scientific, lst_portfolio_scientific)
            query = conn.execute(stmt_sport, lst_portfolio_sport)

        elif len(lst_portfolio_preveducation) == 0:
            query = conn.execute(stmt_del_preveducation)
            query = conn.execute(stmt)
            query = conn.execute(stmt_sociallife, lst_portfolio_sociallife)
            query = conn.execute(stmt_scientific, lst_portfolio_scientific)
            query = conn.execute(stmt_sport, lst_portfolio_sport)

        elif len(lst_portfolio_sociallife) == 0:
            query = conn.execute(stmt_del_sociallife)
            query = conn.execute(stmt)
            query = conn.execute(stmt_preveducation, lst_portfolio_preveducation)
            query = conn.execute(stmt_scientific, lst_portfolio_scientific)
            query = conn.execute(stmt_sport, lst_portfolio_sport)

        elif len(lst_portfolio_scientific) == 0:
            query = conn.execute(stmt_del_scientific)
            query = conn.execute(stmt)
            query = conn.execute(stmt_preveducation, lst_portfolio_preveducation)
            query = conn.execute(stmt_sociallife, lst_portfolio_sociallife)
            query = conn.execute(stmt_sport, lst_portfolio_sport)

        elif len(lst_portfolio_sport) == 0:
            query = conn.execute(stmt_del_sport)
            query = conn.execute(stmt)
            query = conn.execute(stmt_preveducation, lst_portfolio_preveducation)
            query = conn.execute(stmt_sociallife, lst_portfolio_sociallife)
            query = conn.execute(stmt_scientific, lst_portfolio_scientific)

        else:
            query = conn.execute(stmt)
            query = conn.execute(stmt_del_sport)
            query = conn.execute(stmt_del_scientific)
            query = conn.execute(stmt_del_sociallife)
            query = conn.execute(stmt_del_preveducation)
            query = conn.execute(stmt_preveducation, lst_portfolio_preveducation)
            query = conn.execute(stmt_sociallife, lst_portfolio_sociallife)
            query = conn.execute(stmt_scientific, lst_portfolio_scientific)
            query = conn.execute(stmt_sport, lst_portfolio_sport)
        return True

    def get_user_portfolio(self, userid):
        sql = """select portfolio_description,portfolio_character,portfolio_interest,portfolio_health,portfolio_limitations,portfolio_worth from xp_personal_file
where mid=:u"""
        sql2 = """select periods, instutution, major from portfolio_preveducation where mid=:u"""
        sql3 = """select name, participation, results from portfolio_sociallife where mid=:u"""
        sql4 = """select name, participation, results from portfolio_scientific where mid=:u"""
        sql5 = (
            """select name, participation, results from portfolio_sport where mid=:u"""
        )

        conn = current_app.ms.db(self.lname).connect()
        stmt = text(sql)
        stmt = stmt.bindparams(u=userid)
        query = conn.execute(stmt)

        stmt2 = text(sql2)
        stmt2 = stmt2.bindparams(u=userid)
        query2 = conn.execute(stmt2)

        stmt3 = text(sql3)
        stmt3 = stmt3.bindparams(u=userid)
        query3 = conn.execute(stmt3)

        stmt4 = text(sql4)
        stmt4 = stmt4.bindparams(u=userid)
        query4 = conn.execute(stmt4)

        stmt5 = text(sql5)
        stmt5 = stmt5.bindparams(u=userid)
        query5 = conn.execute(stmt5)

        res = [dict(zip(tuple(query.keys()), i)) for i in query.cursor][0]
        res["portfolio_preveducation"] = [
            dict(zip(tuple(query2.keys()), i)) for i in query2.cursor
        ]
        res["portfolio_sociallife"] = [
            dict(zip(tuple(query3.keys()), i)) for i in query3.cursor
        ]
        res["portfolio_scientific"] = [
            dict(zip(tuple(query4.keys()), i)) for i in query4.cursor
        ]
        res["portfolio_sport"] = [
            dict(zip(tuple(query5.keys()), i)) for i in query5.cursor
        ]
        return res

    def get_user_from_sql_detailed(self, userid):
        sql = """select p.mid,login,password,lastname,firstname,patronymic,pos.name positionname, pos.shortname positionshortname, 
ad.name adname, ad.shortname adshortname, ca.cathedra 
from people p
left outer join xp_personal_file pf on p.mid = pf.mid
left outer join positions pos on pos.pid = pf."Position"
left outer join academicdegree ad on ad.agid = pf."AcademicDegree"
left join cathedra_personnel cp on cp.mid = p.mid
left join cathedras ca on ca.idcathedra = cp.cid
where p.mid=:u"""
        conn = current_app.ms.db(self.lname).connect()
        stmt = text(sql)
        stmt = stmt.bindparams(u=userid)
        query = conn.execute(stmt)
        for row in query:
            u = {}
            u["mid"] = row.mid
            u["id"] = row.login
            u["mid"] = row.mid
            u["lastname"] = row.lastname
            u["firstname"] = row.firstname
            u["patronymic"] = row.patronymic
            u["positionname"] = row.positionname
            u["positionshortname"] = row.positionshortname
            u["adname"] = row.adname
            u["adshortname"] = row.adshortname
            u["cathedra"] = row.cathedra
            return u

    def get_user_from_sql_rfid(self, rfid):
        conn = current_app.ms.db(self.lname).connect()
        stmt = text(
            'select p.mid,p.login,p.password,p.lastname,p.firstname,p.patronymic,p.mid, xpf."Phone cell" as contact  from people p join xp_personal_file xpf on p.mid=xpf.mid where xpf.rfidid=:urfid'
        )
        stmt = stmt.bindparams(urfid=rfid)
        query = conn.execute(stmt)
        for row in query:
            u = User(self.lname)
            u.mid = row.mid
            u.id = row.login
            u.mid = row.mid
            u.lastname = row.lastname
            u.firstname = row.firstname
            u.patronymic = row.patronymic
            u.password_hash = row.password
            u.contact = row.contact
            return u

    def get_user_from_sql_id(self, userid):
        # Connect to databse
        # e = create_engine(current_app.config['SQLALCHEMY_DATABASE_URI'], pool_recycle=3600)
        conn = current_app.ms.db(self.lname).connect()
        # Perform query and return JSON data
        # print("DBQ" + userid, file=sys.stderr)
        stmt = text(
            """select p.mid,p.login,p.password,p.lastname,p.firstname,p.patronymic,p.mid, xpf.\"Phone cell\" as contact, \"EMail\" as email, \"EmployerName\" as employername,
            ps.name as position, xpf.PersType as type, military_rank.title militaryrank, d.name as division 
            from vw_people p 
            join xp_personal_file xpf on p.mid=xpf.mid
            left outer join positions          ps on ps.pid = xpf.\"Position\" 
            left outer join permission2mid     pm on pm.mid = p.mid
            left outer join permission_groups  pg on pg.pmid = pm.pmid
            left outer join military_rank on xpf."MilitaryRank" = military_rank.id_mil_rank
            left outer join  vw_staff s on s.mid = p.mid 
            left outer join vw_divisions d on s.depid = d.id            
            left join teachers on teachers.mid=p.mid 
            where p.mid=:u"""
        )
        stmt = stmt.bindparams(u=userid)
        # "select login,password from people where login='"+username+"'"
        query = conn.execute(stmt)
        for row in query:
            u = User(self.lname)
            u.mid = row.mid
            u.id = row.login
            u.mid = row.mid
            u.lastname = row.lastname
            u.firstname = row.firstname
            u.patronymic = row.patronymic
            u.password_hash = row.password
            u.contact = row.contact
            u.email = row.email
            u.employername = row.employername
            u.position = row.position
            u.type = row.type
            u.militaryrank = row.militaryrank
            u.division = row.division
            return u

    def search_user(self, searchparameter):
        conn = current_app.ms.db(self.lname).connect()

        sql = """select mid, lastname, firstname, patronymic from people where (lastname like :u or firstname like :u or patronymic like :u)"""
        stmt = text(sql)
        searchparameter = "%" + searchparameter + "%"
        stmt = stmt.bindparams(u=searchparameter)
        # "select login,password from people where login='"+username+"'"
        query = conn.execute(stmt)
        userDetails = {
            "userSearchResult": [
                dict(zip(tuple(query.keys()), i)) for i in query.cursor
            ]
        }
        return userDetails

    def get_teacher_details_id(self, userid):
        conn = current_app.ms.db(self.lname).connect()
        sql = """
        SELECT 
            positions.name "Position",
            dep.name "Podr",
            (SELECT json_agg(
                        json_build_object(
                            'depname', t.depname,
                            'posrate', t.posrate,
                            'posname', t.posname
                        )
                        ORDER BY t.posrate DESC, t.depname, t.posname
                    ) AS result
                    FROM (
                        SELECT 
                            dep.depname,
                            dep.rate / 100.0 as posrate,
                            p.name as posname
                        FROM xp_personal_file pf
                        JOIN (
                            SELECT cs.cathedra as depname, cp.positionid,cp.rate,cp.mid FROM cathedra_personnel cp JOIN cathedras cs ON cs.idcathedra=cp.cid WHERE cp.pos_overlay
                            UNION
                            SELECT f.faculty as depname, fp.positionid,fp.rate,fp.mid FROM faculty_personnel fp JOIN faculty f ON fp.facultyid=f.idfaculty WHERE fp.pos_overlay
                            UNION
                            SELECT d.divisionname as depname, dp.positionid,dp.rate,dp.mid FROM division_personnel dp JOIN struct_divisions d ON d.sdid=dp.sdid WHERE dp.pos_overlay
                        ) dep ON dep.mid=pf.mid
                        JOIN positions p ON p.pid=dep.positionid
                        WHERE pf.mid = 1
                        ORDER BY 2 DESC,1,3) t
                    ) combining
        FROM people 
        LEFT OUTER JOIN xp_personal_file ON people.mid = xp_personal_file.mid
        LEFT OUTER JOIN positions ON xp_personal_file."Position" = positions.pid
        LEFT OUTER JOIN (
            SELECT 1 as kind, cp.mid,positionid,cs.cathedra as name FROM cathedra_personnel cp      
                JOIN cathedras cs ON cs.idcathedra=cp.cid
                WHERE cp.mid>0 and not coalesce(pos_overlay,false)  
            UNION SELECT 2 as kind,fp.mid,positionid, f.faculty as name FROM faculty_personnel  fp 
                JOIN faculty f ON f.idfaculty=fp.facultyid
                WHERE fp.mid>0 and not coalesce(pos_overlay,false)  
            UNION SELECT 3 as kind,dp.mid,positionid,d.divisionname as name FROM division_personnel dp 
            JOIN struct_divisions d ON d.sdid=dp.sdid
            WHERE dp.mid>0 and not coalesce(pos_overlay,false)  
            ) dep ON dep.mid = people.mid
        WHERE people.mid = :u			
        """

        stmt = text(sql)
        stmt = stmt.bindparams(u=userid)
        # "select login,password from people where login='"+username+"'"
        query = conn.execute(stmt)
        userDetails = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        return userDetails

    def get_user_details_id(self, userid):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
        SELECT 
            lastname, firstname, patronymic,
            COALESCE(svoc.name, pf.category_stat) AS categor,
            cathedras.cathedra,
            faculty.faculty,
            g.name groupname,
            ey.number yeducationyearid,
            (	select kurs || ' курс'
                from vw_group_terms 
                where gid = g.gid and CURRENT_DATE BETWEEN term_begin and term_end
                order by term_begin
                limit 1
            ) AS yeducationyear,
            pf.Number,
            pf.sex,
            COALESCE(
                c.name, 
                (SELECT o.name FROM okin o
                 JOIN okin_razdel r ON o.idRazdel = r.idRazdel AND r.Code = '02'
                 WHERE pf.CitizenOKIN = o.idOkin)
            ) AS country,
            pf.ResidingAddress address,
            pf."Phone cell",
            pf."EMail",
            military_rank.title militaryrank,
            pf."OfficialCapacity",
            pf."Biography",
            pf."LookDescript",
            pf."Hobby",
            pf."HealthStatus",
            pf."Weakness",
            pf."Strength",
            pf."Phone home",
            g.idcathedra cathedraid,
            faculty.idfaculty facultyid,
            COALESCE(ed."EduForm", 'Очная') AS eduform,
            COALESCE(LENGTH(pf.photo), 0) AS photosize,
            g.gid
        FROM people p
        LEFT OUTER JOIN xp_personal_file pf  ON pf.mid = p.mid
        LEFT OUTER JOIN prep_struc_category psc ON pf.category = psc.cid
        LEFT OUTER JOIN xp_subjects sub ON sub.idSubject = pf.ResidingSubject
        LEFT OUTER JOIN xp_countries c ON c.IDCountry = pf.ResidingCountry
        LEFT OUTER JOIN groupuser gu ON p.mid = gu.mid AND gu.cid = -1
        LEFT OUTER JOIN groupname g ON gu.gid = g.gid AND g.cid = -1
        LEFT OUTER JOIN cathedras ON cathedras.idcathedra = g.idcathedra
        LEFT OUTER JOIN faculty ON faculty.idfaculty = COALESCE(g.idfaculty, cathedras.faculty)
        LEFT OUTER JOIN educationyears ey ON ey.number = g.year
        LEFT OUTER JOIN military_rank ON military_rank.id_mil_rank = pf."MilitaryRank"
        LEFT JOIN militaryprofession mp ON mp.mpid = pf.specialisationid
        LEFT JOIN edu_direction ed ON ed.edu_direct_id = mp.edu_direct_id
		LEFT JOIN c_svo_category_personal svoc ON svoc.id = pf.SVORank
        WHERE p.mid = :u
        """

        stmt = text(sql)
        stmt = stmt.bindparams(u=userid)
        # "select login,password from people where login='"+username+"'"
        query = conn.execute(stmt)
        userDetails = {
            "userDetails": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        }
        return userDetails

    def get_user_details_photo(self, userid):
        conn = current_app.ms.db(self.lname).connect()

        sql = """select 
pf.photo
from people p
left outer join xp_personal_file pf
            left outer join prep_struc_category cat on pf.category = cat.cid 
             LEFT OUTER JOIN xp_subjects sub ON sub.idSubject = pf.ResidingSubject
             LEFT OUTER JOIN xp_countries c ON c.IDCountry = pf.ResidingCountry
            on pf.mid = p.mid
where p.mid = :u"""

        stmt = text(sql)
        stmt = stmt.bindparams(u=userid)
        # "select login,password from people where login='"+username+"'"
        query = conn.execute(stmt)

        for row in query:
            if row[0] is not None:
                if sys.version_info[0] < 3:
                    file = row[0]
                else:
                    file = row[0].tobytes()
                contentstr = file
                return contentstr

        return None

    def get_group_for_user(self, userid):
        conn = current_app.ms.db(self.lname).connect()
        stmt = text("select gid from groupuser where cid=-1 and mid=:u")
        stmt = stmt.bindparams(u=userid)
        query = conn.execute(stmt)
        for row in query:
            return row.gid

        return None

    def search_student_list_depr(self, args, name=None):
        conn = current_app.ms.db(self.lname).connect()

        count = False
        where = " "

        if "count" in args.keys():
            if args["count"]:
                count = True

        pagination = ""
        if "paginateFrom" in args.keys():
            if "maxResults" in args.keys():
                pagination = (
                        " LIMIT "
                        + str(int(args["maxResults"]))
                        + " OFFSET "
                        + str(int(args["paginateFrom"]))
                        + " "
                )

        if "group" in args.keys():
            where += " AND g.gid = " + str(int(args["group"]))

        if "faculty" in args.keys():
            where += " AND f.idfaculty = " + str(int(args["faculty"]))
        if "kurs" in args.keys():
            where += " AND gh.year = " + str(int(args["kurs"]))
        if "search" in args.keys():
            where += (
                    " AND p.LastName || ' ' || p.FirstName ||  ' ' || p.Patronymic ilike '%"
                    + args["search"]
                    + "%'"
            )

        if name is not None:
            where += " and (CONCAT(p.LastName , p.FirstName , p.Patronymic) ilike '%{name}%') ".format(
                name=name
            )

        # status_where = """
        #             and coalesce(
        #       (select st."Type"
        #                     from groupuser_transfer gut
        #                     left outer join xp_status st on st.xp_key = gut.xp_status
        #                     where gut.cid = -1 and gut.mid = p.MID
        #                     order by xp_date desc
        #                    limit 1), ' ') not in ('Отчисление', 'Выпуск')
        #             """
        status_where = ""
        if "status" in args.keys():
            if args["status"] == "current":
                status_where = """
                        and coalesce(
                            (select st."Type"
                            from groupuser_transfer gut
                            left outer join xp_status st on st.xp_key = gut.xp_status
                            where gut.cid = -1 and gut.mid = p.MID
                            order by xp_date desc
                           limit 1), ' ') not in ('Отчисление', 'Выпуск')
                        """
            if args["status"] == "deducted":
                status_where = """
                        and coalesce(
                            (select st."Type"
                            from groupuser_transfer gut
                            left outer join xp_status st on st.xp_key = gut.xp_status
                            where gut.cid = -1 and gut.mid = p.MID
                            order by xp_date desc
                           limit 1), ' ') in ('Отчисление')
                        """
            if args["status"] == "graduates":
                status_where = """
                        and coalesce(
                            (select st."Type"
                            from groupuser_transfer gut
                            left outer join xp_status st on st.xp_key = gut.xp_status
                            where gut.cid = -1 and gut.mid = p.MID
                            order by xp_date desc
                           limit 1), ' ') in ('Выпуск')
                        """
            if args["status"] == "archieved":
                status_where = """
                        and coalesce(
                            (select st."Type"
                            from groupuser_transfer gut
                            left outer join xp_status st on st.xp_key = gut.xp_status
                            where gut.cid = -1 and gut.mid = p.MID
                            order by xp_date desc
                           limit 1), ' ') in ('Архивная запись')
                        """
            if args["status"] == "new":
                status_where = """
                        and coalesce(
                            (select st."Type"
                            from groupuser_transfer gut
                            left outer join xp_status st on st.xp_key = gut.xp_status
                            where gut.cid = -1 and gut.mid = p.MID
                            order by xp_date desc
                           limit 1), ' ') in ('Поступление')
                        """

        year_condition = "(select xp_key from school_year where now() between begdate and enddate) -- по текущемму году"
        if "year" in args.keys():
            year_condition = "({})".format(args["year"])

        sql = """select 
 p.mid, p.LastName , p.FirstName , p.Patronymic, to_char(xpf.birthday,'DD.MM.YYYY') birthday, g.name groupname
from people p
left outer join groupuser gu on p.mid = gu.mid and gu.cid = -1
left outer join groupname g on gu.gid = g.gid and g.cid = -1
left join cathedras cs on cs.idcathedra=g.idcathedra
join faculty f on f.idfaculty=coalesce(g.idfaculty,cs.faculty)
join group_history gh on gh.gid=g.gid 
  and gh.school_year in {year_condition}
join xp_personal_file xpf on p.mid=xpf.mid
where  p.LastName || p.FirstName || p.Patronymic > '' and p.mid in (select mid from students)
              {status_where}""".format(
            status_where=status_where, year_condition=year_condition
        )

        sql = (
                sql
                + where
                + "order by UPPER(p.LastName), UPPER(p.FirstName), UPPER(p.Patronymic) "
        )
        if count:
            sql = "select count(*) from (" + sql + ") eee"
        else:
            sql = sql + pagination
        print(sql)
        stmt = text(sql)

        query = conn.execute(stmt)

        result = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return result

    def search_teacher_list_v2(self, nameparameter, args, admin_flag, mid):

        conn = current_app.ms.db(self.lname).connect()

        print("args: {}".format(args))

        # Определение необходимости подсчёта
        count = bool(str(args.get("count", "false")).lower() in ("true", "1", "yes"))

        # Пагинация
        pagination = ""
        if ("paginateFrom" in args or "offset" in args) and ("maxResults" in args or "limit" in args):
            pagination = (
                    " LIMIT " + str(int(args.get("maxResults") or args.get("limit"))) +
                    " OFFSET " + str(int(args.get("paginateFrom") or args.get("offset")))
            )

        status = ""
        if "status" in args.keys():
            if args["status"] != "all":
                if args["status"] == "dismissed":
                    status = "Уволен"
                if args["status"] == "works":
                    status = "Работает"
                if args["status"] == "relocated":
                    status = "Переведен к новому месту службы"
                if args["status"] == "external":
                    status = "Внешний совместитель"
                if args["status"] == "archieved":
                    status = "Архивная запись"
                if args["status"] == "service":
                    status = "Служебная учётная запись"

        name_parameter = ""
        if nameparameter:
            name_parameter = "WHERE xp_f_get_mid_fio(pf.mid, 0) ILIKE '%{}%'".format(nameparameter)

        stmt = """
                -- Удаление временной таблицы, если она существует
                DROP TABLE IF EXISTS tmp_division_struct;

                -- Создание временной таблицы для формирования структуры подразделений
                CREATE TEMPORARY TABLE tmp_division_struct AS
                WITH RECURSIVE dep AS (
                    SELECT 
                        id, 
                        "name", 
                        owner_dep, 
                        "name"::text AS fullname
                    FROM vw_divisions
                    WHERE owner_dep IS NULL
                    UNION ALL
                    SELECT 
                        vd.id, 
                        vd."name", 
                        vd.owner_dep, 
                        CONCAT(dep."name", ' / ', vd."name") AS fullname
                    FROM dep
                    JOIN vw_divisions vd ON vd.owner_dep = dep.id
                )
                SELECT DISTINCT 
                    dep.id, 
                    dep.fullname
                FROM dep
                JOIN vw_staff vs ON dep.id = vs.depid;

                -- Основной запрос для формирования отчёта по сотрудникам
                SELECT DISTINCT
                    pf.mid, 
                    xp_f_get_mid_fio(pf.mid, 0) AS "Фамилия Имя Отчество",
                    pf.workstatus AS _workstatus, 
                    pf.Sex AS "Пол", 
                    to_char(pf.Birthday,'DD.MM.YYYY') AS "Дата рождения",
                    position_name AS "Должность", 
                    division_name AS "Подразделение", 
                    division_struct AS "Подразделение в структуре",
                    ROUND((
                        CASE COALESCE(p.lastname, '') WHEN '' THEN 0 ELSE 1 END +
                        CASE COALESCE(p.firstname, '') WHEN '' THEN 0 ELSE 1 END +
                        CASE COALESCE(pf.sex, '') WHEN '' THEN 0 ELSE 1 END +
                        CASE WHEN pf.Birthday IS NULL THEN 0 ELSE 1 END +
                        CASE WHEN pf.perstype = 'Военнослужащие' AND COALESCE(pf."MilitaryRank", 0) > 0 THEN 1 ELSE 0 END +
                        CASE COALESCE(pf.persstate, '') WHEN '' THEN 0 ELSE 1 END +
                        CASE COALESCE(pf.perstype, '') WHEN '' THEN 0 ELSE 1 END +
                        CASE COALESCE(pf.SVORank, 0) WHEN 0 THEN 0 ELSE 1 END +
                        CASE COALESCE(pf."EducationalInstitutionName", '') WHEN '' THEN 0 ELSE 1 END +
                        CASE WHEN pf."GraduationDate" IS NULL THEN 0 ELSE 1 END +
                        CASE COALESCE(pf."GraduationCertificateNumber", '') WHEN '' THEN 0 ELSE 1 END +
                        CASE COALESCE(pf."EducationLevel", '') WHEN '' THEN 0 ELSE 1 END +
                        CASE COALESCE(pf.DocumentWhoGive, '') WHEN '' THEN 0 ELSE 1 END +
                        CASE WHEN pf.DocumentWhenGive IS NULL THEN 0 ELSE 1 END +
                        CASE COALESCE(pf.DocumentType, '') WHEN '' THEN 0 ELSE 1 END +
                        CASE COALESCE(pf.DocumentNumber, '') WHEN '' THEN 0 ELSE 1 END +
                        CASE COALESCE(pf.DocumentSeria, '') WHEN '' THEN 0 ELSE 1 END +
                        CASE COALESCE(pf."PassportIssuerEntityCode", '') WHEN '' THEN 0 ELSE 1 END
                    ) * 100.0 / (17.0 + CASE WHEN pf.perstype = 'Военнослужащие' THEN 1 ELSE 0 END)) AS "% заполнения ЛД",
                    p.login::varchar(10) AS "Логин", 
                    pf.RegistrationAddress AS "Адрес проживания",
                    (
                        SELECT STRING_AGG(pg."name", ', ') 
                        FROM permission2mid p2m 
                        JOIN permission_groups pg ON p2m.pmid = pg.pmid 
                        WHERE p2m.mid = pf.mid
                    ) AS "Роль",
                    pf.DocumentType AS "Тип документа", 
                    pf.DocumentSeria AS "Серия", 
                    pf.DocumentNumber AS "Номер", 
                    pf."Phone cell" AS "Телефон мобильный",
                    CASE 
                        WHEN COALESCE(LENGTH(pf.Photo), 0) > 0 THEN 1 
                        ELSE 0 
                    END AS "Фото",
                    pf."EducationLevel" AS "Уровень образования", 
                    pf."All exp" AS "Общий стаж", 
                    pf."Ped exp" AS "Педагогический стаж", 
                    pf.DateLastCert::date AS "Дата аттестации", 
                    pf.DateIncludingPansion AS "Дата приёма на работу", 
                    pf.PersType AS "Тип персонала", 
                    pf.category_stat AS "Категория",
                    military_rank.title AS "Воинское звание"
                    FROM (
                        SELECT 
                            pf.xp_pf_id, 
                            pf.mid, 
                            STRING_AGG(DISTINCT CASE WHEN vd.shortname IS NULL OR vd.shortname = '' THEN vd."name" ELSE vd.shortname END, ', ') AS division_name, 
                            STRING_AGG(DISTINCT tds.fullname, E'\n') AS division_struct, 
                            STRING_AGG(pos."name", ', ') AS position_name 
                        FROM xp_personal_file pf 
                        LEFT JOIN vw_staff vs ON pf.mid = vs.mid 
                        LEFT JOIN vw_divisions vd ON vs.depid = vd.id 
                        LEFT JOIN positions pos ON vs.positionid = pos.pid 
                        LEFT JOIN tmp_division_struct tds ON vd.id = tds.id
                        WHERE (1 = 1)
        """
        if not admin_flag:
            stmt += """
            AND vd.id IN (
                SELECT DISTINCT vs.depid
                FROM permission2mid p2m
                JOIN permission_groups pg ON p2m.pmid = pg.pmid
                JOIN vw_staff vs ON vs.depid = ANY(pg.sdid)
                WHERE p2m.mid = :mid
            )
            """
        if "division" in args.keys():
            division = (
                    "AND vd.id = " + str(int(args["division"]))
            )
            stmt += division

        stmt += """
            AND pf.workstatus = :workstatus
            GROUP BY pf.mid, pf.xp_pf_id
        ) AS q 
        INNER JOIN xp_personal_file pf ON q.xp_pf_id = pf.xp_pf_id 
        INNER JOIN people p ON pf.mid = p.mid 
        LEFT OUTER JOIN military_rank ON military_rank.id_mil_rank = pf."MilitaryRank"
        JOIN teachers t ON p.mid = t.mid
        """
        stmt = text(stmt + name_parameter + pagination + ";")
        print("stmt: {}".format(stmt))
        query = conn.execute(stmt, {"mid": mid, "workstatus": status})
        query = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        if count:
            return [{"count": len(query)}]
        result = []

        for row in query:
            u = User(None)
            u.mid = row["mid"]
            fio = row["Фамилия Имя Отчество"].split(" ")
            u.lastname = fio[0] if len(fio) > 0 else ""
            u.firstname = fio[1] if len(fio) > 1 else ""
            u.patronymic = fio[2] if len(fio) > 2 else ""
            u.birthday = row["Дата рождения"]
            u.email = row["Логин"]
            u.employername = row["Подразделение в структуре"]
            u.position = row["Должность"]
            u.type = row["Тип персонала"]
            u.militaryrank = row["Воинское звание"]
            u.division = row["Подразделение"]
            result.append(u)

        return result

    def search_teacher_list(self, nameparameter, args):
        conn = current_app.ms.db(self.lname).connect()

        count = False

        if "count" in args.keys():
            if args["count"]:
                count = True

        pagination = ""
        if "paginateFrom" in args.keys():
            if "maxResults" in args.keys():
                pagination = (
                        " LIMIT "
                        + str(int(args["maxResults"]))
                        + " OFFSET "
                        + str(int(args["paginateFrom"]))
                        + " "
                )

        where = ""
        if nameparameter is not None:
            where = " and (fio ilike :np) "

        if "status" in args.keys():
            if args["status"] != "all":
                status = ""
                if args["status"] == "dismissed":
                    status = "Уволен"
                if args["status"] == "works":
                    status = "Работает"
                if args["status"] == "relocated":
                    status = "Переведен к новому месту службы"
                if args["status"] == "external":
                    status = "Внешний совместитель"
                if args["status"] == "archieved":
                    status = "Архивная запись"
                where += " AND xpf.workstatus = '" + status + "'"

        if "division" in args.keys():
            where = (
                    where
                    + " and  vw_people.mid in (select mid from division_personnel where sdid | 268435456 = "
                    + str(int(args["division"]))
                    + " union select mid from faculty_personnel where facultyid = "
                    + str(int(args["division"]))
                    + " union select mid from cathedra_personnel where cid | 536870912 = "
                    + str(int(args["division"]))
                    + " )"
            )

        SQL = """select distinct(vw_people.mid), lastname, firstname, patronymic, to_char(xpf.birthday,'DD.MM.YYYY') birthday, coalesce(length(xpf.photo),0) as photosize,
                    xpf.\"Phone cell\" as contact, \"EMail\" as email, \"EmployerName\" as employername,
                    ps.name as position, xpf.PersType as type, military_rank.title militaryrank, d.name as division
                    from vw_people
                    join teachers on teachers.mid=vw_people.mid
                    join xp_personal_file xpf on vw_people.mid=xpf.mid
                    left outer join positions          ps on ps.pid = xpf.\"Position\"
                    left outer join permission2mid     pm on pm.mid = vw_people.mid
                    left outer join permission_groups  pg on pg.pmid = pm.pmid
                    left outer join military_rank on xpf."MilitaryRank" = military_rank.id_mil_rank
                    left outer join  vw_staff s on s.mid = vw_people.mid
                    left outer join vw_divisions d on s.depid = d.id
                    """

        SQL = (
                SQL + " where 1 =1 " + where + " order by lastname, firstname " + pagination
        )

        CSQL = (
                """
            select count(distinct(vw_people.mid))
            from vw_people
            join teachers on teachers.mid=vw_people.mid
            join xp_personal_file xpf on vw_people.mid=xpf.mid
            where 1=1"""
                + where
        )
        print(SQL, CSQL)
        if count:
            stmt = text(CSQL)
        else:
            stmt = text(SQL)

        if nameparameter is not None:
            nameparameter = "%" + nameparameter + "%"
            stmt = stmt.bindparams(np=nameparameter)

        query = conn.execute(stmt)
        result = []
        if count:
            c = Count()
            for row in query:
                c.count = row.count
                result.append(c)
        else:
            for row in query:
                u = User(None)
                u.mid = row.mid
                u.lastname = row.lastname
                u.firstname = row.firstname
                u.patronymic = row.patronymic
                u.birthday = row.birthday
                u.email = row.email
                u.photosize = row.photosize
                u.contact = row.contact
                u.email = row.email
                u.employername = row.employername
                u.position = row.position
                u.type = row.type
                u.militaryrank = row.militaryrank
                u.division = row.division

                result.append(u)
        return result

    def serialize(self):
        return {
            "id": self.mid,
            "firstname": self.firstname,
            "patronymic": self.patronymic,
            "lastname": self.lastname,
            "gid": self.gid,
            "photosize": self.photosize,
            "contact": self.contact,
            "email": self.email,
            "birthday": self.birthday,
            "employername": self.employername,
            "position": self.position,
            "type": self.type,
            "militaryrank": self.militaryrank,
            "division": self.division,
        }

    def generate_auth_token(self):
        print(current_app)
        key = current_app.config["SECRET_KEY"]
        expiration = current_app.config["TOKEN_VALID"]
        s = Serializer(key, expires_in=expiration)
        return s.dumps({"id": self.id})

    @staticmethod
    def verify_auth_token(token):
        key = current_app.config["SECRET_KEY"]
        s = Serializer(key)
        try:
            data = s.loads(token)
        except SignatureExpired:
            return None  # valid token, but expired
        except BadSignature:
            return None  # invalid token
        except:
            # print('Invalid token ' + token, file=sys.stderr)
            return None  # nothing walks around

        fo = request.path.split("/")
        lname = fo[4]
        u = User(lname)
        user = u.get_user_from_db(data["id"])

        return user

    def hash_password(self, password):
        passwd = password.encode("utf-8")
        pass1 = hashlib.sha1(passwd).digest()
        pass2 = hashlib.sha1(pass1).hexdigest()
        return "*" + pass2.upper()

    def verify_password(self, password):
        # current_app.logger.debug(self.lname)

        hashedPass = self.hash_password(password)

        if hashedPass == self.password_hash:
            return True
        else:
            return False

    def change_password(self, newpassword):
        conn = current_app.ms.db(self.lname).connect()
        self.prepare_logger(conn)
        stmt = text("update people set password=:p,need_change_password=0 where mid=:u")
        stmt = stmt.bindparams(p=self.hash_password(newpassword))
        stmt = stmt.bindparams(u=self.mid)

        conn.execute(stmt)
        self.password_hash = self.hash_password(newpassword)
        self.set_user_to_redis()

    def get_password_filters(self, lname):
        conn = current_app.ms.db(lname).connect()
        stmt = text(
            "select encode((value::bytea), 'escape')::text from options where name in ('password_case', 'password_length', 'password_min', 'password_count')"
        )
        filters = conn.execute(stmt)
        if filters:
            filters_values = []
            for filter in filters:
                filters_values.append(filter[0])
            return filters_values
        else:
            return False

    def check_user_try(self, lname, login, min):
        conn = current_app.ms.db(lname).connect()
        sql = """
            SELECT COUNT(*) FROM security_log
            WHERE username = '{login}' AND issue_type = 1
            AND issue_time >= current_timestamp - ({min} * interval '1 minute')
        """.format(
            login=login, min=min
        )
        stmt = text(sql)
        query = conn.execute(stmt)
        for r in query:
            return r[0]

    def block_user_try(self, lname, login, data):
        conn = current_app.ms.db(lname).connect()
        sql = """
           UPDATE people SET blocked = 1 WHERE login = {login} 
        """.format(
            login=login
        )
        stmt = text(sql)
        conn.execute(stmt)
        if request.environ.get("HTTP_X_FORWARDED_FOR") is None:
            ip = request.environ["REMOTE_ADDR"]
        else:
            ip = request.environ["HTTP_X_FORWARDED_FOR"]
        sql = """
            INSERT INTO security_log(issue_time,
            fromip, mid, username, computername,
            subsystem, "version",
            issue_type, messagetype, message )
            VALUES (NOW(), {fromip}, {mid}, {username}, {computername}, {subsystem}, {version},
            6, {messagetype}, {message}); 
        """.format(
            fromip=data[0],
            mid=data[1],
            username=login,
            computername=ip,
            subsystem="ЛМС ВУЗ",
            version=current_app.vesion,
            messagetype="Подбор пароля",
            message="Пользователь заблокирован (подбор пароля)",
        )
        stmt = text(sql)
        conn.execute(stmt)

    def write_log(self, login, mid, ip, version):
        sql = """insert into xp_login_register (login, mid, dateenter, isweb, computername, version) values (:login, :mid, now(),1, :ip, :version)"""
        conn = current_app.ms.db(self.lname).connect()

        User(self.lname).prepare_logger(conn)
        stmt = text(sql)
        stmt = stmt.bindparams(login=login)
        stmt = stmt.bindparams(mid=mid)
        stmt = stmt.bindparams(ip=ip)
        stmt = stmt.bindparams(version=version)
        conn.execute(stmt)
        return True

    def addStudent(self, student):
        conn = current_app.ms.db(self.lname).connect()

        sql = """INSERT INTO people(lastname, firstname, patronymic, birthdate)
        VALUES (:lastname, :firstname, :patronymic, :birthdate);"""
        stmt = text(sql)

        stmt = stmt.bindparams(lastname=student["lastname"])
        stmt = stmt.bindparams(firstname=student["firstname"])
        stmt = stmt.bindparams(patronymic=student["patronymic"])
        stmt = stmt.bindparams(birthdate=student["birthdate"])

        conn.execute(stmt)

        sql = "SELECT currval(pg_get_serial_sequence('people','mid'))"
        stmt = text(sql)
        query = conn.execute(stmt)
        newId = 0
        for row in query:
            newId = row.currval
            # insert into xp_personal_file and student
            sql = """INSERT INTO students(mid, cid, cgid, registered, time_registered)
                VALUES (:mid, 0, 0, 1, now());"""
            stmt = text(sql)
            stmt = stmt.bindparams(mid=newId)
            conn.execute(stmt)

            sql = """INSERT INTO xp_personal_file(mid, birthday)
                VALUES (:mid, :birthday);"""
            stmt = text(sql)
            stmt = stmt.bindparams(mid=newId)
            stmt = stmt.bindparams(birthday=student["birthdate"])
            conn.execute(stmt)

        return newId

    def addTeacher(self, teacher):
        conn = current_app.ms.db(self.lname).connect()

        sql = """INSERT INTO people(lastname, firstname, patronymic, birthdate)
        VALUES (:lastname, :firstname, :patronymic, :birthdate);"""
        stmt = text(sql)

        stmt = stmt.bindparams(lastname=teacher["lastname"])
        stmt = stmt.bindparams(firstname=teacher["firstname"])
        stmt = stmt.bindparams(patronymic=teacher["patronymic"])
        stmt = stmt.bindparams(birthdate=teacher["birthdate"])

        conn.execute(stmt)

        sql = "SELECT currval(pg_get_serial_sequence('people','mid'))"
        stmt = text(sql)
        query = conn.execute(stmt)
        newId = 0
        for row in query:
            newId = row.currval
            # insert into xp_personal_file and student
            sql = """INSERT INTO teachers(mid, cid)
                VALUES (:mid, -1);"""
            stmt = text(sql)
            stmt = stmt.bindparams(mid=newId)
            conn.execute(stmt)

            sql = """INSERT INTO xp_personal_file(mid, birthday)
                VALUES (:mid, :birthday);"""
            stmt = text(sql)
            stmt = stmt.bindparams(mid=newId)
            stmt = stmt.bindparams(birthday=teacher["birthdate"])
            conn.execute(stmt)

        return newId

    def getUserBiography(self, lname, id):
        conn = current_app.ms.db(lname).connect()

        sql = text(
            """
            SELECT *
            FROM personal_files
            WHERE id = :id AND document_type = 0;
        """
        )
        stmt = sql.bindparams(id=id)
        query = conn.execute(stmt)

        result = {
            "biography": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        }

        if len(result["biography"]) == 0:
            return None

        return result

    # create and update students
    def createStudentUser(self, lname, data=None):
        if data is None:
            data = {}
        conn = current_app.ms.db(lname).connect()
        User(lname).prepare_logger(conn)

        stmt = text(
            """
            SELECT
                parent.name rasdel_name,
                xp_access_rasdel.name object_name,
            CASE MAX(CASE xp_access.value
                        WHEN 'Нет' THEN 0
                        WHEN 'Чтение' THEN 1
                        WHEN 'Полный' THEN 2
                        ELSE -1
                        END)
                WHEN 0 THEN 'Нет'
                WHEN 1 THEN 'Чтение'
                WHEN 2 THEN 'Полный'
                ELSE 'Нет'
            END AS "value"
    
    
            FROM xp_access
            INNER JOIN xp_access_rasdel ON xp_access_rasdel.xp_key = xp_access.rasdel 
                AND xp_access_rasdel."name" IN ('Переменный состав', 'Переменный состав. Главная', 'Переменный состав. Прочие сведения',
                                      'Переменный состав. Обучение', 'Переменный состав. Документы',
                                      'Переменный состав. Физическая подготовка')
            INNER JOIN xp_access_rasdel parent ON xp_access_rasdel.parent = parent.xp_key
            AND parent.parent = 0 AND parent.xp_key <>   '21'  
            INNER JOIN permission2mid ON xp_access.role = permission2mid.pmid AND permission2mid.mid = '{id}'
            WHERE "value" = 'Полный'
            GROUP BY rasdel_name, object_name
            UNION SELECT
            parent.name rasdel_name,
            xp_report.name object_name,
            CASE MAX(CASE xp_access.value
                        WHEN 'Нет' THEN 0
                        WHEN 'Чтение' THEN 1
                        WHEN 'Полный' THEN 2
                        ELSE -1
                        END)
                WHEN 0 THEN 'Нет'
                WHEN 1 THEN 'Чтение'
                WHEN 2 THEN 'Полный'
                ELSE 'Нет'
            END AS "value"
            FROM xp_access
            INNER JOIN xp_report ON xp_report.xp_rpt_id = xp_access.report_id
            INNER JOIN xp_access_rasdel parent ON xp_access.rasdel = parent.xp_key 
                AND parent."name" IN ('Переменный состав', 'Переменный состав. Главная', 'Переменный состав. Прочие сведения',
                                      'Переменный состав. Обучение', 'Переменный состав. Документы',
                                      'Переменный состав. Физическая подготовка')																				
            AND parent.parent = 0 AND parent.xp_key =   '21'
            INNER JOIN permission2mid ON xp_access.role = permission2mid.pmid AND permission2mid.mid = '{id}'
            WHERE "value" = 'Полный'
            GROUP BY rasdel_name, object_name
        """.format(
                id=g.user.mid
            )
        )

        query = conn.execute(stmt)
        res = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        if len(res) != 6:
            return False
        # запрос для изменения данных
        sql = """
            INSERT INTO people (
                lastname, firstname, patronymic
            ) VALUES (
                '{lastname}', '{firstname}', '{patronymic}'
            ) RETURNING mid;
        """.format(
            lastname=data.get("lastname") or "null",
            firstname=data.get("firstname") or "null",
            patronymic=data.get("patronymic") or "null",
        )
        mid_query = conn.execute(text(sql))
        mid = mid_query.fetchone()[0]

        sql = """
        INSERT INTO xp_personal_file (
            mid, sex, number, birthplace, birthday, militarydistrictarrival,
            liter, documenttype, documentseria, passportseria,
            documentnumber, passportnumber, documentwhogive, 
            documentwhengive, passportdate, education, vuz, 
            specialisation, "Scn degree", datelastcert, "SocialStatusID",
            mil_rank, "MilitaryRank", "BloodGroup", "Rh",
            "PhysicalFitnessDesc", "MilitaryServiceTraining", familystatus,
            svorank, "MIdN", nationality, f_commissariat, "EMail",
            "EducationLevel", "EducationProfile", gradebook
        ) VALUES (
            {mid}, '{sex}', '{number}', '{birthplace}', '{birthday}', '{militarydistrictarrival}',
            '{liter}', '{documenttype}', '{documentseria}', '{documentseria}',
            '{documentnumber}', '{documentnumber}', '{documentwhogive}', 
            '{documentwhengive}', '{passportdate}', '{education}', '{vuz}', 
            '{specialisation}', '{scn_degree}', '{datelastcert}', '{socialstatusid}',
            '{mil_rank}', {mil_rank}, '{blood_group}', '{rh}',
            '{physical_fitness_desc}', '{military_service_training}', '{family_status}',
            {svorank}, '{midn}', {nationality}, {f_commissariat}, '{email}',
            '{education_level}', '{education_profile}', '{gradebook}'
        ) RETURNING xp_pf_id;
        """.format(
            mid=mid,
            lastname=data.get("lastname") or "null",
            firstname=data.get("firstname") or "null",
            patronymic=data.get("patronymic") or "null",
            sex=data.get("sex") or "null",
            number=data.get("number") or "null",
            birthplace=data.get("birthplace") or "null",
            birthday=data.get("birthday") or "null",
            militarydistrictarrival=data.get("militarydistrictarrival") or "null",
            liter=data.get("liter") or "null",
            documenttype=data.get("documenttype") or "null",
            documentseria=data.get("documentseria") or "null",
            documentnumber=data.get("documentnumber") or "null",
            documentwhogive=data.get("documentwhogive") or "null",
            documentwhengive=data.get("documentwhengive") or "null",
            passportdate=data.get("documentwhengive") or "null",
            education=data.get("education") or "null",
            vuz=data.get("vuz") or "null",
            specialisation=data.get("specialisation") or "null",
            scn_degree=data.get("scn_degree") or "null",
            datelastcert=data.get("datelastcert") or "null",
            socialstatusid=data.get("socialstatusid") or "null",
            mil_rank=data.get("mil_rank") or "null",
            blood_group=data.get("blood_group") or "null",
            rh=data.get("rh") or "null",
            physical_fitness_desc=data.get("physical_fitness_desc") or "null",
            military_service_training=data.get("military_service_training") or "null",
            midn=data.get("midn") or "null",
            family_status=data.get("family_status") or "null",
            svorank=data.get("svorank") or "null",
            nationality=data.get("nationality") or "null",
            f_commissariat=data.get("f_commissariat") or "null",
            email=data.get("email") or "null",
            education_level=data.get("education_level") or "null",
            education_profile=data.get("education_profile") or "null",
            gradebook=data.get("gradebook") or "null",
        )
        xp_id_query = conn.execute(text(sql))
        xp_id = xp_id_query.fetchone()[0]
        return {"mid": mid, "xp_pf_id": xp_id}

    def updateStudentUser(self, lname, mid: int, data=None):
        if data is None:
            data = {}
        conn = current_app.ms.db(lname).connect()
        User(lname).prepare_logger(conn)

        stmt = text(
            """
            SELECT
                parent.name rasdel_name,
                xp_access_rasdel.name object_name,
            CASE MAX(CASE xp_access.value
                        WHEN 'Нет' THEN 0
                        WHEN 'Чтение' THEN 1
                        WHEN 'Полный' THEN 2
                        ELSE -1
                        END)
                WHEN 0 THEN 'Нет'
                WHEN 1 THEN 'Чтение'
                WHEN 2 THEN 'Полный'
                ELSE 'Нет'
            END AS "value"


            FROM xp_access
            INNER JOIN xp_access_rasdel ON xp_access_rasdel.xp_key = xp_access.rasdel 
                AND xp_access_rasdel."name" IN ('Переменный состав', 'Переменный состав. Главная', 'Переменный состав. Прочие сведения',
                                      'Переменный состав. Обучение', 'Переменный состав. Документы',
                                      'Переменный состав. Физическая подготовка')
            INNER JOIN xp_access_rasdel parent ON xp_access_rasdel.parent = parent.xp_key
            AND parent.parent = 0 AND parent.xp_key <>   '21'  
            INNER JOIN permission2mid ON xp_access.role = permission2mid.pmid AND permission2mid.mid = '{id}'
            WHERE "value" = 'Полный'
            GROUP BY rasdel_name, object_name
            UNION SELECT
            parent.name rasdel_name,
            xp_report.name object_name,
            CASE MAX(CASE xp_access.value
                        WHEN 'Нет' THEN 0
                        WHEN 'Чтение' THEN 1
                        WHEN 'Полный' THEN 2
                        ELSE -1
                        END)
                WHEN 0 THEN 'Нет'
                WHEN 1 THEN 'Чтение'
                WHEN 2 THEN 'Полный'
                ELSE 'Нет'
            END AS "value"
            FROM xp_access
            INNER JOIN xp_report ON xp_report.xp_rpt_id = xp_access.report_id
            INNER JOIN xp_access_rasdel parent ON xp_access.rasdel = parent.xp_key 
                AND parent."name" IN ('Переменный состав', 'Переменный состав. Главная', 'Переменный состав. Прочие сведения',
                                      'Переменный состав. Обучение', 'Переменный состав. Документы',
                                      'Переменный состав. Физическая подготовка')																				
            AND parent.parent = 0 AND parent.xp_key =   '21'
            INNER JOIN permission2mid ON xp_access.role = permission2mid.pmid AND permission2mid.mid = '{id}'
            WHERE "value" = 'Полный'
            GROUP BY rasdel_name, object_name
        """.format(
                id=g.user.mid
            )
        )

        query = conn.execute(stmt)
        res = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        if len(res) != 6:
            return False
        # запрос для изменения данных
        sql = """
            UPDATE people SET
                lastname='{lastname}', firstname='{firstname}', patronymic='{patronymic}'
            WHERE mid={mid} RETURNING mid;
        """.format(
            lastname=data.get("lastname") or "null",
            firstname=data.get("firstname") or "null",
            patronymic=data.get("patronymic") or "null",
            mid=mid,
        )
        mid_query = conn.execute(text(sql))
        res_mid = mid_query.fetchone()[0]

        sql = """
        UPDATE xp_personal_file SET
            sex='{sex}', number='{number}', birthplace='{birthplace}', birthday='{birthday}',
            militarydistrictarrival='{militarydistrictarrival}', 
            liter='{liter}', documenttype='{documenttype}', documentseria='{documentseria}', 
            passportseria='{documentseria}', documentnumber='{documentnumber}',
            passportnumber='{documentnumber}', documentwhogive='{documentwhogive}', 
            documentwhengive='{documentwhengive}', passportdate='{passportdate}', education='{education}',
            vuz='{vuz}', specialisation='{specialisation}', "Scn degree"='{scn_degree}', 
            datelastcert='{datelastcert}', "SocialStatusID"='{socialstatusid}',
            mil_rank='{mil_rank}', "MilitaryRank"={mil_rank}, "BloodGroup"='{blood_group}', "Rh"='{rh}',
            "PhysicalFitnessDesc"='{physical_fitness_desc}', 
            "MilitaryServiceTraining"='{military_service_training}', familystatus='{family_status}',
            svorank={svorank}, "MIdN"='{midn}', nationality={nationality}, 
            f_commissariat={f_commissariat}, "EMail"='{email}',
            "EducationLevel"='{education_level}', "EducationProfile"='{education_profile}', gradebook='{gradebook}'
        WHERE mid={mid} RETURNING xp_pf_id;
        """.format(
            mid=mid,
            lastname=data.get("lastname") or "null",
            firstname=data.get("firstname") or "null",
            patronymic=data.get("patronymic") or "null",
            sex=data.get("sex") or "null",
            number=data.get("number") or "null",
            birthplace=data.get("birthplace") or "null",
            birthday=data.get("birthday") or "null",
            militarydistrictarrival=data.get("militarydistrictarrival") or "null",
            liter=data.get("liter") or "null",
            documenttype=data.get("documenttype") or "null",
            documentseria=data.get("documentseria") or "null",
            documentnumber=data.get("documentnumber") or "null",
            documentwhogive=data.get("documentwhogive") or "null",
            documentwhengive=data.get("documentwhengive") or "null",
            passportdate=data.get("documentwhengive") or "null",
            education=data.get("education") or "null",
            vuz=data.get("vuz") or "null",
            specialisation=data.get("specialisation") or "null",
            scn_degree=data.get("scn_degree") or "null",
            datelastcert=data.get("datelastcert") or "null",
            socialstatusid=data.get("socialstatusid") or "null",
            mil_rank=data.get("mil_rank") or "null",
            blood_group=data.get("blood_group") or "null",
            rh=data.get("rh") or "null",
            physical_fitness_desc=data.get("physical_fitness_desc") or "null",
            military_service_training=data.get("military_service_training") or "null",
            midn=data.get("midn") or "null",
            family_status=data.get("family_status") or "null",
            svorank=data.get("svorank") or "null",
            nationality=data.get("nationality") or "null",
            f_commissariat=data.get("f_commissariat") or "null",
            email=data.get("email") or "null",
            education_level=data.get("education_level") or "null",
            education_profile=data.get("education_profile") or "null",
            gradebook=data.get("gradebook"),
        )
        xp_id_query = conn.execute(text(sql))
        xp_id = xp_id_query.fetchone()[0]
        return {"mid": mid, "xp_pf_id": xp_id}

    # create and update teachers
    # methods are like for students but there are other permissions for user
    # and fields in tables
    def createTeacherUser(self, lname, data=None):
        if data is None:
            data = {}
        conn = current_app.ms.db(lname).connect()
        User(lname).prepare_logger(conn)

        stmt = text(
            """
            SELECT
                parent.name rasdel_name,
                xp_access_rasdel.name object_name,
            CASE MAX(CASE xp_access.value
                        WHEN 'Нет' THEN 0
                        WHEN 'Чтение' THEN 1
                        WHEN 'Полный' THEN 2
                        ELSE -1
                        END)
                WHEN 0 THEN 'Нет'
                WHEN 1 THEN 'Чтение'
                WHEN 2 THEN 'Полный'
                ELSE 'Нет'
            END AS "value"


            FROM xp_access
            INNER JOIN xp_access_rasdel ON xp_access_rasdel.xp_key = xp_access.rasdel 
                AND xp_access_rasdel."name" IN ('Постоянный состав', 'Постоянный состав. Главная', 
                                      'Постоянный состав. Состав семьи',
                                      'Постоянный состав. Образование', 'Постоянный состав. Прочие сведения',
                                      'Постоянный состав. Физическая подготовка')
            INNER JOIN xp_access_rasdel parent ON xp_access_rasdel.parent = parent.xp_key
            AND parent.parent = 0 AND parent.xp_key <>   '21'  
            INNER JOIN permission2mid ON xp_access.role = permission2mid.pmid AND permission2mid.mid = '{id}'
            WHERE "value" = 'Полный'
            GROUP BY rasdel_name, object_name
            UNION SELECT
            parent.name rasdel_name,
            xp_report.name object_name,
            CASE MAX(CASE xp_access.value
                        WHEN 'Нет' THEN 0
                        WHEN 'Чтение' THEN 1
                        WHEN 'Полный' THEN 2
                        ELSE -1
                        END)
                WHEN 0 THEN 'Нет'
                WHEN 1 THEN 'Чтение'
                WHEN 2 THEN 'Полный'
                ELSE 'Нет'
            END AS "value"
            FROM xp_access
            INNER JOIN xp_report ON xp_report.xp_rpt_id = xp_access.report_id
            INNER JOIN xp_access_rasdel parent ON xp_access.rasdel = parent.xp_key 
                AND parent."name" IN ('Постоянный состав', 'Постоянный состав. Главная', 
                                      'Постоянный состав. Состав семьи',
                                      'Постоянный состав. Образование', 'Постоянный состав. Прочие сведения',
                                      'Постоянный состав. Физическая подготовка')																				
            AND parent.parent = 0 AND parent.xp_key =   '21'
            INNER JOIN permission2mid ON xp_access.role = permission2mid.pmid AND permission2mid.mid = '{id}'
            WHERE "value" = 'Полный'
            GROUP BY rasdel_name, object_name
        """.format(
                id=g.user.mid
            )
        )

        query = conn.execute(stmt)
        res = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        if len(res) != 6:
            return False
        # запрос для изменения данных
        sql = """
            INSERT INTO people (
                lastname, firstname, patronymic
            ) VALUES (
                '{lastname}', '{firstname}', '{patronymic}'
            ) RETURNING mid;
        """.format(
            lastname=data.get("lastname") or "null",
            firstname=data.get("firstname") or "null",
            patronymic=data.get("patronymic") or "null",
        )
        mid_query = conn.execute(text(sql))
        mid = mid_query.fetchone()[0]

        sql = """
        INSERT INTO xp_personal_file (
            mid, sex, number, birthplace, birthday, militarydistrictarrival,
            liter, documenttype, documentseria, passportseria,
            documentnumber, passportnumber, documentwhogive, 
            documentwhengive, passportdate, education, vuz, 
            specialisation, "Scn degree", datelastcert, "SocialStatusID",
            mil_rank, "MilitaryRank", "BloodGroup", "Rh",
            "PhysicalFitnessDesc", "MilitaryServiceTraining", familystatus,
            svorank, nationality, f_commissariat, "EMail", category, inn,
            "INILA", persstate, kindwork, perstype, razryad, nagruzka
            
        ) VALUES (
            {mid}, '{sex}', '{number}', '{birthplace}', '{birthday}', '{militarydistrictarrival}',
            '{liter}', '{documenttype}', '{documentseria}', '{documentseria}',
            '{documentnumber}', '{documentnumber}', '{documentwhogive}', 
            '{documentwhengive}', '{passportdate}', '{education}', '{vuz}', 
            '{specialisation}', '{scn_degree}', '{datelastcert}', '{socialstatusid}',
            '{mil_rank}', {mil_rank}, '{blood_group}', '{rh}',
            '{physical_fitness_desc}', '{military_service_training}', '{family_status}',
            {svorank}, {nationality}, {f_commissariat}, '{email}', {category}, '{inn}',
            '{inila}', '{persstate}', '{kindwork}', '{perstype}', '{razryad}', '{nagruzka}'
            
        ) RETURNING xp_pf_id;
        """.format(
            mid=mid,
            lastname=data.get("lastname") or "null",
            firstname=data.get("firstname") or "null",
            patronymic=data.get("patronymic") or "null",
            sex=data.get("sex") or "null",
            number=data.get("number") or "null",
            birthplace=data.get("birthplace") or "null",
            birthday=data.get("birthday") or "null",
            militarydistrictarrival=data.get("militarydistrictarrival") or "null",
            liter=data.get("liter") or "null",
            documenttype=data.get("documenttype") or "null",
            documentseria=data.get("documentseria") or "null",
            documentnumber=data.get("documentnumber") or "null",
            documentwhogive=data.get("documentwhogive") or "null",
            documentwhengive=data.get("documentwhengive") or "null",
            passportdate=data.get("documentwhengive") or "null",
            education=data.get("education") or "null",
            vuz=data.get("vuz") or "null",
            specialisation=data.get("specialisation") or "null",
            scn_degree=data.get("scn_degree") or "null",
            datelastcert=data.get("datelastcert") or "null",
            socialstatusid=data.get("socialstatusid") or "null",
            mil_rank=data.get("mil_rank") or "null",
            blood_group=data.get("blood_group") or "null",
            rh=data.get("rh") or "null",
            physical_fitness_desc=data.get("physical_fitness_desc") or "null",
            military_service_training=data.get("military_service_training") or "null",
            midn=data.get("midn") or "null",
            family_status=data.get("family_status") or "null",
            svorank=data.get("svorank") or "null",
            nationality=data.get("nationality") or "null",
            category=data.get("category") or "null",
            f_commissariat=data.get("f_commissariat") or "null",
            email=data.get("email") or "null",
            education_level=data.get("education_level") or "null",
            education_profile=data.get("education_profile") or "null",
            inn=data.get("inn"),
            inila=data.get("inila"),
            persstate=data.get("persstate"),
            kindwork=data.get("kindwork"),
            perstype=data.get("perstype"),
            razryad=data.get("razryad"),
            nagruzka=data.get("nagruzka"),
        )
        xp_id_query = conn.execute(text(sql))
        xp_id = xp_id_query.fetchone()[0]
        return {"mid": mid, "xp_pf_id": xp_id}

    def updateTeacherUser(self, lname, mid: int, data=None):
        if data is None:
            data = {}
        conn = current_app.ms.db(lname).connect()
        User(lname).prepare_logger(conn)

        stmt = text(
            """
            SELECT
                parent.name rasdel_name,
                xp_access_rasdel.name object_name,
            CASE MAX(CASE xp_access.value
                        WHEN 'Нет' THEN 0
                        WHEN 'Чтение' THEN 1
                        WHEN 'Полный' THEN 2
                        ELSE -1
                        END)
                WHEN 0 THEN 'Нет'
                WHEN 1 THEN 'Чтение'
                WHEN 2 THEN 'Полный'
                ELSE 'Нет'
            END AS "value"


            FROM xp_access
            INNER JOIN xp_access_rasdel ON xp_access_rasdel.xp_key = xp_access.rasdel 
                AND xp_access_rasdel."name" IN ('Переменный состав', 'Переменный состав. Главная', 'Переменный состав. Прочие сведения',
                                      'Переменный состав. Обучение', 'Переменный состав. Документы',
                                      'Переменный состав. Физическая подготовка')
            INNER JOIN xp_access_rasdel parent ON xp_access_rasdel.parent = parent.xp_key
            AND parent.parent = 0 AND parent.xp_key <>   '21'  
            INNER JOIN permission2mid ON xp_access.role = permission2mid.pmid AND permission2mid.mid = '{id}'
            WHERE "value" = 'Полный'
            GROUP BY rasdel_name, object_name
            UNION SELECT
            parent.name rasdel_name,
            xp_report.name object_name,
            CASE MAX(CASE xp_access.value
                        WHEN 'Нет' THEN 0
                        WHEN 'Чтение' THEN 1
                        WHEN 'Полный' THEN 2
                        ELSE -1
                        END)
                WHEN 0 THEN 'Нет'
                WHEN 1 THEN 'Чтение'
                WHEN 2 THEN 'Полный'
                ELSE 'Нет'
            END AS "value"
            FROM xp_access
            INNER JOIN xp_report ON xp_report.xp_rpt_id = xp_access.report_id
            INNER JOIN xp_access_rasdel parent ON xp_access.rasdel = parent.xp_key 
                AND parent."name" IN ('Переменный состав', 'Переменный состав. Главная', 'Переменный состав. Прочие сведения',
                                      'Переменный состав. Обучение', 'Переменный состав. Документы',
                                      'Переменный состав. Физическая подготовка')																				
            AND parent.parent = 0 AND parent.xp_key =   '21'
            INNER JOIN permission2mid ON xp_access.role = permission2mid.pmid AND permission2mid.mid = '{id}'
            WHERE "value" = 'Полный'
            GROUP BY rasdel_name, object_name
        """.format(
                id=g.user.mid
            )
        )

        query = conn.execute(stmt)
        res = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        if len(res) != 6:
            return False
        # запрос для изменения данных
        sql = """
            UPDATE people SET
                lastname='{lastname}', firstname='{firstname}', patronymic='{patronymic}'
            WHERE mid={mid} RETURNING mid;
        """.format(
            lastname=data.get("lastname") or "null",
            firstname=data.get("firstname") or "null",
            patronymic=data.get("patronymic") or "null",
            mid=mid,
        )
        mid_query = conn.execute(text(sql))
        res_mid = mid_query.fetchone()[0]

        sql = """
        UPDATE xp_personal_file SET
            sex='{sex}', number='{number}', birthplace='{birthplace}', birthday='{birthday}',
            militarydistrictarrival='{militarydistrictarrival}', 
            liter='{liter}', documenttype='{documenttype}', documentseria='{documentseria}', 
            passportseria='{documentseria}', documentnumber='{documentnumber}',
            passportnumber='{documentnumber}', documentwhogive='{documentwhogive}', 
            documentwhengive='{documentwhengive}', passportdate='{passportdate}', education='{education}',
            vuz='{vuz}', specialisation='{specialisation}', "Scn degree"='{scn_degree}', 
            datelastcert='{datelastcert}', "SocialStatusID"='{socialstatusid}',
            mil_rank='{mil_rank}', "MilitaryRank"={mil_rank}, "BloodGroup"='{blood_group}', "Rh"='{rh}',
            "PhysicalFitnessDesc"='{physical_fitness_desc}', 
            "MilitaryServiceTraining"='{military_service_training}', familystatus='{family_status}',
            svorank={svorank}, nationality={nationality}, 
            f_commissariat={f_commissariat}, "EMail"='{email}', inn='{inn}', "INILA"='{inila}',
            persstate='{persstate}', kindwork='{kindwork}', perstype='{perstype}', razryad='{razryad}',
            nagruzka='{nagruzka}'
        WHERE mid={mid} RETURNING xp_pf_id;
        """.format(
            mid=mid,
            lastname=data.get("lastname") or "null",
            firstname=data.get("firstname") or "null",
            patronymic=data.get("patronymic") or "null",
            sex=data.get("sex") or "null",
            number=data.get("number") or "null",
            birthplace=data.get("birthplace") or "null",
            birthday=data.get("birthday") or "null",
            militarydistrictarrival=data.get("militarydistrictarrival") or "null",
            liter=data.get("liter") or "null",
            documenttype=data.get("documenttype") or "null",
            documentseria=data.get("documentseria") or "null",
            documentnumber=data.get("documentnumber") or "null",
            documentwhogive=data.get("documentwhogive") or "null",
            documentwhengive=data.get("documentwhengive") or "null",
            passportdate=data.get("documentwhengive") or "null",
            education=data.get("education") or "null",
            vuz=data.get("vuz") or "null",
            specialisation=data.get("specialisation") or "null",
            scn_degree=data.get("scn_degree") or "null",
            datelastcert=data.get("datelastcert") or "null",
            socialstatusid=data.get("socialstatusid") or "null",
            mil_rank=data.get("mil_rank") or "null",
            blood_group=data.get("blood_group") or "null",
            rh=data.get("rh") or "null",
            physical_fitness_desc=data.get("physical_fitness_desc") or "null",
            military_service_training=data.get("military_service_training") or "null",
            midn=data.get("midn") or "null",
            family_status=data.get("family_status") or "null",
            svorank=data.get("svorank") or "null",
            nationality=data.get("nationality") or "null",
            category=data.get("category") or "null",
            f_commissariat=data.get("f_commissariat") or "null",
            email=data.get("email") or "null",
            education_level=data.get("education_level") or "null",
            education_profile=data.get("education_profile") or "null",
            inn=data.get("inn"),
            inila=data.get("inila"),
            persstate=data.get("persstate"),
            kindwork=data.get("kindwork"),
            perstype=data.get("perstype"),
            razryad=data.get("razryad"),
            nagruzka=data.get("nagruzka"),
        )
        xp_id_query = conn.execute(text(sql))
        xp_id = xp_id_query.fetchone()[0]
        return {"mid": mid, "xp_pf_id": xp_id}

    def uploadUsersPhoto(self, lname, mid: int, photo=None):
        conn = current_app.ms.db(lname).connect()
        User(lname).prepare_logger(conn)

        stmt = text(
            """UPDATE xp_personal_file SET photo=:photo WHERE mid={mid}""".format(
                mid=mid
            )
        )
        conn.execute(stmt, photo=photo)
        return {"mid": mid}

    def allowed_modes(self, lname, user_id):
        sql = """
            SELECT  
               parent.Name RasdelName,  
               xp_access_rasdel.Name ObjectName,  
               CASE Max(FIND_IN_SET(xp_access.value, 'Нет,Чтение,Полный')) 
               WHEN 2 THEN 'Чтение' 
               WHEN 3 THEN 'Полный' 
               ELSE 'Нет' 
               END "value" 
             FROM xp_access 
             INNER JOIN xp_access_rasdel ON xp_access_rasdel.xp_Key = xp_access.Rasdel 
             INNER JOIN xp_access_rasdel parent ON xp_access_rasdel.parent = parent.xp_Key 
               AND parent.parent = 0 AND parent.xp_Key <>  21
             INNER JOIN permission2mid ON xp_access.Role = permission2mid.pmid AND permission2mid.mid = :user_id
             GROUP BY RasdelName, ObjectName 
             UNION 
             SELECT 
               parent.Name RasdelName, 
               xp_report.Name ObjectName, 
               CASE Max(FIND_IN_SET(xp_access.value, 'Нет,Чтение,Полный')) 
               WHEN 2 THEN 'Чтение' 
               WHEN 3 THEN 'Полный' 
               ELSE 'Нет' 
               END "value" 
             FROM xp_access 
             INNER JOIN xp_report ON xp_report.xp_rpt_id = xp_access.Report_id 
             INNER JOIN xp_access_rasdel parent ON xp_access.Rasdel = parent.xp_Key 
               AND parent.parent = 0 AND parent.xp_Key =  21
             INNER JOIN permission2mid ON xp_access.Role = permission2mid.pmid AND permission2mid.mid = :user_id
             GROUP BY RasdelName, ObjectName
        """

        conn = current_app.ms.db(lname).connect()

        stmt = text(sql)

        stmt = stmt.bindparams(user_id=user_id)

        query = conn.execute(stmt)

        result = {}
        for access_mode in query.cursor:
            if not access_mode[0] in result:
                result[access_mode[0]] = {}

            result[access_mode[0]][access_mode[1]] = access_mode[2]

        self.access_modes = result

        return result

    def get_practice_grades(self):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
            select mid, c.cid, c.title, tg.trmid, grade, gn.gid, qdp.q_practice_id, qdp.study_place, qdp.cid, qdp.eyid, qdp.tlid, tl.name, gh.year 
            from term_grades tg
            JOIN courses c ON tg.cid = c.cid
            JOIN discipline_groups g on g.dis_group_id = any(c.dis_group_ids || c.dis_group_id)
            JOIN discipline_cycles dc ON g.dis_cycle_id = dc.dis_cycle_id
            JOIN discipline_blocks b ON dc.block = b.id and b.block_type = 1
            JOIN journalcertification jc on jc.jcid = tg.jcid
            JOIN groupname gn on gn.gid = jc.gid
            join qualif_demands q on q.mpid=gn.f_militaryprofession
            join curriculum clm on clm.q_demand_id=q.q_demand_id
            join studyyears2curriculum s2c on s2c.idcurriculum=clm.idcurriculum and s2c.syid=gn.syid  
            JOIN terms t ON t.trmid = tg.trmid
            JOIN group_history gh ON gh.gid = gn.gid AND gh.school_year = t.year
            join TermsList tl on  tl.number::integer = gh.year * 2 - (select count(*) from terms t1 where t1.year = t.year and t.term_begin::date < t1.term_begin::date) 
            left join q_demand_practice qdp on qdp.q_demand_id = q.q_demand_id and qdp.tlid = tl.tlid and qdp.cid = c.cid
            where tg.mid = :mid and tg.trmtid in (7, 9)
        """

        stmt = text(sql)
        stmt = stmt.bindparams(mid=g.user.mid)
        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def search_student_list(self, args, group_list, mid, name=None, is_admin=1):
        conn = current_app.ms.db(self.lname).connect()

        count = bool(str(request.args.get("count", "false")).lower() in ("true", "1", "yes"))

        pagination = ""
        if "paginateFrom" or "offset" in args.keys():
            if "maxResults" or "limit" in args.keys():
                pagination = (
                        " LIMIT "
                        + str(int(args["maxResults"] or args["limit"]))
                        + " OFFSET "
                        + str(int(args["paginateFrom"] or args["offset"]))
                        + " "
                )

        if "catname" in args.keys():
            where = " WHERE psc.name = :catname "
        else:
            where = " WHERE p.mid in (select mid from students) "

        if name is not None:
            where += " and (CONCAT(p.LastName , p.FirstName , p.Patronymic) ilike '%{name}%') ".format(
                name=name
            )

        if "search" in args.keys():
            where += (
                    " AND p.LastName || ' ' || p.FirstName ||  ' ' || p.Patronymic ilike '%"
                    + args["search"]
                    + "%'"
            )

        graduate_fields = ""
        graduate_joins = ""

        if "status" in args.keys():
            if args["status"] == "current":
                if group_list:
                    where += " AND gn.gid IN :group_list "
                where += """ AND COALESCE(st."Type", '') NOT IN ('Отчисление', 'Выпуск', 'Архивная запись')  """
            if args["status"] == "deducted":
                where += """
                    AND (SELECT xp_date FROM groupuser_transfer gt2 WHERE gt2.mid = p.mid ORDER BY xp_date DESC LIMIT 1) BETWEEN 
                        (SELECT begdate FROM school_year sy WHERE sy.xp_key = :year) AND 
                        (SELECT enddate FROM school_year sy WHERE sy.xp_key = :year) AND COALESCE(st."Type", '') = 'Отчисление'
                """
            if args["status"] == "graduates":
                if "year" in args.keys():
                    where += """
                        AND (SELECT xp_date FROM groupuser_transfer gt2 WHERE gt2.mid = p.mid ORDER BY xp_date DESC LIMIT 1) BETWEEN 
                            (SELECT begdate FROM school_year sy WHERE sy.xp_key = :year) AND 
                            (SELECT enddate FROM school_year sy WHERE sy.xp_key = :year) AND COALESCE(st."Type", '') = 'Выпуск'
                        """
                else:
                    where += """ AND COALESCE(st."Type", '') = 'Выпуск' """
                graduate_fields = """
                , 
                COALESCE(cmr.shortname, cmr."name") AS "Распределение", 
                COALESCE(cmb.shortname, cmb."name") AS "Вид и Род войск", 
                CASE WHEN nr.is_processed = 1 THEN TRUE ELSE FALSE END AS "Обработан",
                tf."name" AS "Войск. соединение"
                """
                graduate_joins = """
                LEFT JOIN cmilitarybranches cmb ON cmb.cmilitarybranches = pf.dist_militarybranch
                LEFT JOIN cmilitaryregion cmr ON cmr.cmilitaryregion = pf.dist_militaryregion
                LEFT JOIN nnz_review nr ON nr.mid = pf.mid
                LEFT JOIN xp_troop_formation tf ON tf.id = nr.troop_formation_id
                """
            if args["status"] == "archieved":
                where += """ AND COALESCE(st."Type", '') = 'Архивная запись' """
            if args["status"] == "new":
                where += """
                    AND COALESCE(st."Type", '') IN ('', 'Поступление')
                    AND gn."name" IS NULL
                """
            if not is_admin:
                where += """
                AND (
                (
                   SELECT STRING_AGG(a, ',') 
                   FROM (
                       SELECT UNNEST(pg.sdid)::varchar AS a 
                       FROM permission2mid p2m 
                       JOIN permission_groups pg ON p2m.pmid = pg.pmid 
                       WHERE p2m.mid = pf.whocreate_mid
                   ) q
                ) =
                (
                   SELECT STRING_AGG(a, ',') 
                   FROM (
                       SELECT UNNEST(pg.sdid)::varchar AS a 
                       FROM permission2mid p2m 
                       JOIN permission_groups pg ON p2m.pmid = pg.pmid 
                       WHERE p2m.mid = :mid
                   ) q
                )
                OR EXISTS (
                    SELECT pm.mid
                    FROM permission2mid pm
                    JOIN permission2mid pm2 
                        ON pm2.pmid = pm.pmid
                        AND pm2.mid = pf.whocreate_mid 
                    WHERE pm.mid = :mid
                )
                OR pf.whocreate_mid = :mid)
                """

        sql = """
            SELECT 
                p.mid, 
                xp_pf_id, 
                xp_format_fio(p.LastName,p.FirstName,p.Patronymic,0)::varchar(100) "Фамилия Имя Отчество", 
                p.LastName , p.FirstName , p.Patronymic,
                COALESCE(pf.Sex, '')::varchar(10) "Пол", 
                pf.Birthday birthday, 
                gn."name"::varchar(50) groupname, 
                p.Login "Логин", 
                st."name" AS "Статус", 
                psc."name" "Категория", 
                p.LastName as "Фамилия", p.FirstName as "Имя", p.Patronymic as "Отчество", 
                co."name" AS "Страна", 
                xp_format_fio(t2.LastName,t2.FirstName,t2.Patronymic,1)::varchar(254) "Наставник", 
                xp_format_fio(t.LastName,t.FirstName,t.Patronymic,1)::varchar(254) "Куратор", 
                CASE 
                    WHEN COALESCE(LENGTH(pf.Photo), 0) > 0 THEN 1 
                    ELSE 0 
                END::boolean "Фото", 
                (SELECT string_agg(privilegecode, '') FROM xp_personal_file_privilege pv WHERE pv.mid = p.mid AND TRIM(privilegecode) > '') "Льготы", 
                sub.Subject AS "Субъект РФ", 
                pf.MilitaryDistrictArrival AS "Военный округ прибытия", 
                pff.MilitaryBranch AS "Род войск (отец)", 
                pff2.MilitaryBranch AS "Род войск (мать)" 
                {graduate_fields}
            FROM people p 
            JOIN xp_personal_file pf ON pf.mid = p.mid 
            LEFT JOIN groupuser gu ON gu.mid = p.mid 
            LEFT JOIN groupname gn ON gu.gid = gn.gid AND gn.cid=-1 AND gn.owner_gid=0 
            LEFT JOIN group_history gh ON gh.gid = gn.gid 
                AND CASE 
                    WHEN :year = 0 THEN 
                        gh.school_year = (
                            SELECT school_year 
                            FROM group_history 
                            WHERE gid = gn.gid 
                            ORDER BY "year" DESC 
                            LIMIT 1
                            ) 
                    ELSE gh.school_year = :year
                END 
            LEFT JOIN people t on t.mid = gn.class_teacher 
            LEFT JOIN people t2 on t2.mid = gn.class_teacher2 
            LEFT JOIN prep_struc_category psc ON pf.category = psc.cid 
            LEFT OUTER JOIN xp_countries co ON co.IDCountry = pf.ResidingCountry 
            LEFT OUTER JOIN xp_subjects sub ON sub.idSubject = pf.ResidingSubject 
            LEFT JOIN xp_personal_file_family pff ON pff.mid=p.mid AND pff.Relationship in ('Отец') 
            LEFT JOIN xp_personal_file_family pff2 ON pff2.mid=p.mid AND pff2.Relationship in ('Мать') 
            {graduate_joins}
            LEFT JOIN c_svo_category_personal svo ON svo.id = pf.SVORank 
            LEFT JOIN xp_status st ON st.xp_key = ( 
              SELECT xs.xp_key 
              FROM groupuser_transfer gt 
              JOIN xp_status xs ON gt.xp_status = xs.xp_key 
              WHERE gt.mid = p.mid 
              ORDER BY gt.xp_date DESC, gt.xp_key DESC 
              LIMIT 1) 
            {where}
            ORDER BY "Фамилия Имя Отчество"
        """.format(
            graduate_fields=graduate_fields,
            graduate_joins=graduate_joins,
            where=where
        )

        if count:
            sql = "select count(*) from (" + sql + ") eee"
        else:
            sql = sql + pagination
        stmt = text(sql)

        params = dict(args)
        params["year"] = int(args["year"] or args["xp_key"])
        params["mid"] = mid
        params["group_list"] = group_list
        if "catname" in args.keys():
            params["catname"] = args["catname"]
        query = conn.execute(stmt, params)

        result = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return result

    def check_students_or_teachers_mid(self, mid):
        conn = current_app.ms.db(self.lname).connect()

        # Проверяем наличие mid в таблицах
        check_sql = """
            SELECT
                EXISTS (
                    SELECT 1
                    FROM students
                    WHERE mid = :mid
                ) AS is_student,
                EXISTS (
                    SELECT 1
                    FROM teachers
                    WHERE mid = :mid
                ) AS is_teacher;
        """
        check_stmt = text(check_sql).bindparams(mid=mid)
        check_result = conn.execute(check_stmt).fetchone()

        return check_result['is_student'], check_result['is_teacher']

    def get_student_stats(self, mid):
        conn = current_app.ms.db(self.lname).connect()

        # Проверяем наличие mid в таблицах
        sql = """
            SELECT 
                pf.mid,
                ROUND(CASE COALESCE(pf.foreigncitizen,0) 
                    WHEN 0 THEN 
                    ( 
                    case coalesce(p.lastname,'') when '' then 0 else 1 end + 
                    case coalesce(p.firstname,'') when '' then 0 else 1 end + 
                    case coalesce(pf."number",'') when '' then 0 else 1 end + 
                    case  when pf.Birthday is null then 0 else 1 end +
                    case coalesce(pf.sex,'') when '' then 0 else 1 end +
                    case coalesce(pf.ResidingCountry,0) when 0 then 0 else 1 end + 
                    case coalesce(pf.ResidingSubject,0) when 0 then 0 else 1 end + 
                    case coalesce(pf.ResidingIndex,'') when '' then 0 else 1 end + 
                    case coalesce(pf.ResidingAddress,'') when '' then 0 else 1 end + 
                    case coalesce(pf.ResidingTown,'') when '' then 0 else 1 end + 
                    case coalesce(pf.nationality,0) when 0 then 0 else 1 end + 
                    case coalesce(pf.familystatus,'') when '' then 0 else 1 end + 
                    case coalesce(pf.RegistrationAddress,'') when '' then 0 else 1 end + 
                    case coalesce(pf."MilitaryRank",0) when 0 then 0 else 1 end + 
                    case coalesce(pf.SVORank,0) when 0 then 0 else 1 end + 
            
                    case coalesce(pf."EducationLevel",'') when '' then 0 else 1 end + 
                    case when pf."GraduationDate" is null then 0 else 1 end + 
                    case coalesce(pf."EducationalInstitutionName",'') when '' then 0 else 1 end + 
                    case coalesce(pf."GraduationCertificateNumber",'') when '' then 0 else 1 end +
            
                    case coalesce(pf."SocialSostav",'') when '' then 0 else 1 end + 
                    case coalesce(pf."SocialStatusID",0) when 0 then 0 else 1 end + 
            
                    case coalesce(pf.DocumentWhoGive,'') when '' then 0 else 1 end + 
                    case when pf.DocumentWhenGive is null then 0 else 1 end + 
                    case coalesce(pf.DocumentType,'') when '' then 0 else 1 end + 
                    case coalesce(pf.DocumentNumber,'') when '' then 0 else 1 end + 
                    case coalesce(pf.DocumentSeria,'') when '' then 0 else 1 end + 
                    case coalesce(pf."PassportIssuerEntityCode",'') when '' then 0 else 1 end 
            
            
                    )*100.0 /27.0 
                    WHEN 1 THEN 
                    ( 
                    case coalesce(p.lastname,'') when '' then 0 else 1 end +
                    case coalesce(p.firstname,'') when '' then 0 else 1 end + 
                    case  when pf.Birthday is null then 0 else 1 end + 
                    case coalesce(pf.sex,'') when '' then 0 else 1 end + 
                    case coalesce(pf.ResidingCountry,0) when 0 then 0 else 1 end + 
                    case coalesce(pf.nationality,0) when 0 then 0 else 1 end + 
                    case coalesce(pf."MilitaryRank",0) when 0 then 0 else 1 end + 
                    case coalesce(pf.category,0) when 0 then 0 else 1 end + 
                    case coalesce(pf.SVORank,0) when 0 then 0 else 1 end + 
                    case coalesce(LENGTH(pf.Photo),0) when 0 then 0 else 1 end 
                    )*100.0 /10.0 
                END)::float  AS completeness
            FROM people p
            LEFT JOIN xp_personal_file pf ON pf.mid = p.mid
            WHERE p.mid = :mid
        """
        stmt = text(sql).bindparams(mid=mid)
        result = conn.execute(stmt).fetchone()
        return result["completeness"]

    def get_teachers_stats(self, mid):
        conn = current_app.ms.db(self.lname).connect()

        # Проверяем наличие mid в таблицах
        sql = """
            SELECT 
                pf.mid,
                ROUND(
                    CASE COALESCE(p.lastname, '') WHEN '' THEN 0 ELSE 1 END +  -- Last name
                    CASE COALESCE(p.firstname, '') WHEN '' THEN 0 ELSE 1 END +  -- First name
                    CASE COALESCE(pf.sex, '') WHEN '' THEN 0 ELSE 1 END +  -- Sex
                    CASE WHEN pf.Birthday IS NULL THEN 0 ELSE 1 END +  -- Birthday
                    CASE WHEN pf.perstype = 'Военнослужащие' AND COALESCE(pf."MilitaryRank", 0) > 0 THEN 1 ELSE 0 END +  -- Military rank
                    CASE COALESCE(pf.persstate, '') WHEN '' THEN 0 ELSE 1 END +  -- Work nature
                    CASE COALESCE(pf.perstype, '') WHEN '' THEN 0 ELSE 1 END +  -- Type
                    CASE COALESCE(pf.SVORank, 0) WHEN 0 THEN 0 ELSE 1 END +  -- SVO category
                    CASE COALESCE(pf."EducationalInstitutionName", '') WHEN '' THEN 0 ELSE 1 END +  -- Educational institution
                    CASE WHEN pf."GraduationDate" IS NULL THEN 0 ELSE 1 END +  -- Graduation date
                    CASE COALESCE(pf."GraduationCertificateNumber", '') WHEN '' THEN 0 ELSE 1 END +  -- Graduation certificate number
                    CASE COALESCE(pf."EducationLevel", '') WHEN '' THEN 0 ELSE 1 END +  -- Education level
                    CASE COALESCE(pf.DocumentWhoGive, '') WHEN '' THEN 0 ELSE 1 END +  -- Issued by
                    CASE WHEN pf.DocumentWhenGive IS NULL THEN 0 ELSE 1 END +  -- Issued date
                    CASE COALESCE(pf.DocumentType, '') WHEN '' THEN 0 ELSE 1 END +  -- Document type
                    CASE COALESCE(pf.DocumentNumber, '') WHEN '' THEN 0 ELSE 1 END +  -- Document number
                    CASE COALESCE(pf.DocumentSeria, '') WHEN '' THEN 0 ELSE 1 END +  -- Document series
                    CASE COALESCE(pf."PassportIssuerEntityCode", '') WHEN '' THEN 0 ELSE 1 END  -- Passport issuer code
                ) * 100.0 / (
                    17.0 + CASE WHEN pf.perstype = 'Военнослужащие' THEN 1 ELSE 0 END
                ) AS completeness
            FROM people p
            LEFT JOIN xp_personal_file pf ON pf.mid = p.mid
            WHERE p.mid = :mid
        """
        stmt = text(sql).bindparams(mid=mid)
        result = conn.execute(stmt).fetchone()
        return result["completeness"]

    @staticmethod
    def get_teacher_by_cathedra_meta_course(lname: str, idcathedra: int, meta_course: int, search: str, limit: int,
                                            offset: int):
        where = ""
        args = {}

        if idcathedra:
            where += " AND cc.cathedraid = :idcathedra "
            args["idcathedra"] = idcathedra
        if meta_course:
            where += " AND mc.id = :meta_course "
            args["meta_course"] = meta_course
        if search:
            where += " AND (p.lastname || ' ' || p.firstname || ' ' || COALESCE(p.patronymic, '')) ILIKE :search "
            args["search"] = "%{search}%".format(search=search)

        # SQL для подсчёта общего количества
        count_sql = """
            SELECT COUNT(DISTINCT p.mid) AS total
            FROM teachers t
            JOIN people p ON t.mid = p.mid
            JOIN xp_personal_file pf ON pf.mid=p.mid AND pf.workstatus='Работает'
            LEFT JOIN course2cathedra cc ON cc.cid = t.cid
            LEFT JOIN courses c ON cc.cid = c.cid
            LEFT JOIN meta_course mc ON c.meta_course = mc.id
            WHERE 1=1 {where}
        """.format(where=where)

        # SQL для получения данных с лимитом/оффсетом
        data_sql = """
            SELECT DISTINCT p.mid, p.lastname || ' ' || p.firstname || ' ' || COALESCE(p.patronymic, '') AS fio
            FROM teachers t
            JOIN people p ON t.mid = p.mid
            JOIN xp_personal_file pf ON pf.mid=p.mid AND pf.workstatus='Работает'
            LEFT JOIN course2cathedra cc ON cc.cid = t.cid
            LEFT JOIN courses c ON cc.cid = c.cid
            LEFT JOIN meta_course mc ON c.meta_course = mc.id
            WHERE 1=1 {where}
            ORDER BY fio
            {limit_offset}
        """

        conn = current_app.ms.db(lname).connect()

        # Получаем общее количество
        count_result = conn.execute(text(count_sql), args).scalar()

        # Получаем данные
        args_with_limit = args.copy()
        limit_offset = ""
        if limit:
            limit_offset += " LIMIT :limit "
            args_with_limit.update({"limit": limit})
        if offset:
            limit_offset += " OFFSET :offset "
            args_with_limit.update({"offset": offset})
        query = conn.execute(text(data_sql.format(where=where, limit_offset=limit_offset)), args_with_limit)
        rows = query.fetchall()

        return {
            "count": count_result,
            "result": [dict(row) for row in rows]
        }

