import hashlib
import os
import re
from flask import current_app
from sqlalchemy import text

from LMSAPI.api.Models.LoginRegister import LoginRegister

class UserActionLog:

    @staticmethod
    def create_log(
        lname: str,
        action_source: str,
        action_type: int,
        filename: str,
        base_file_dir: str,
        file_path: str,
        login: str,
        user_mid: int,
        ip_address: str,
    ) -> None:
        
        xp_key = LoginRegister.get_last_xp_key_session(lname=lname, login=login)
        
        hash_file = None
        with open(os.path.join(file_path, filename), "rb") as file:
            hash_file = '\\x' + hashlib.md5(file.read()).hexdigest().upper()

        file_path = re.sub(base_file_dir + '/', '', file_path).replace('/', '\\')

        sql = """
        INSERT INTO user_action_log
        (
            action_time,
            action_source,
            version,
            action_type,
            action_info,
            hash,
            description,
            login,
            mid,
            login_register,
            address
        )
        VALUES (
            now(),
            {action_source},
            null,
            {action_type},
            {filename},
            {hash_file},
            {file_path},
            {login},
            {user_mid},
            {xp_key},
            {ip_address}
        )
        """.format(
            action_source="'{action_source}'".format(action_source=action_source) if action_source else "null",
            action_type=action_type if action_type else "null",
            filename="'{filename}'".format(filename=filename) if filename else "null",
            hash_file="'{hash_file}'".format(hash_file=hash_file) if hash_file else "null",
            file_path="'{file_path}'".format(file_path=file_path) if file_path else "null",
            login="'{login}'".format(login=login) if login else "null",
            user_mid=user_mid if user_mid else "null",
            xp_key=xp_key if xp_key else "null",
            ip_address="'{ip_address}'".format(ip_address=ip_address) if ip_address else "null",
        )

        conn = current_app.ms.db(lname).connect()
        conn.execute(text(sql))
    
    @staticmethod
    def get_logs(
        lname: str,
    ) -> list:
        sql = """
        SELECT
                action_time,
                action_source,
                version,
                action_type,
                action_info,
                hash,
                description,
                login,
                mid,
                login_register,
                address

        FROM user_action_log
        """

        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return [dict(r) for r in query]