from flask import Flask,jsonify, g
from sqlalchemy import create_engine
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.Division import Division
from flask_cors import CORS

from LMSAPI.api.utils.swagger_comments import SwaggerComments
from LMSAPI.api.utils.swagger_utils import swagger_doc

division_api = Blueprint('division_api', __name__)

CORS(division_api)

@division_api.route('/lms/api/v1.0/<lname>/divisions_list', methods=['GET'])
# @auth.login_required
def getActiveDivisions(lname):
    divisionList = Division().getActiveDivisions(lname)
    
    if divisionList is None:
        return jsonify(success=False),404

    return jsonify(divisionList)


@division_api.route('/lms/api/v1.0/<lname>/divisions', methods=['GET'])
@auth.login_required
@swagger_doc(SwaggerComments.division_api_get_divisions_permanent_staff)
def get_divisions_permanent_staff(lname):
    """
    Получить список подразделений (режим "Постоянный состав")
    """
    admin_flag = g.user.access_modes["Справочники"]["Постоянный состав. Администратор"] in ["Полный"]
    if admin_flag:
        divisionList = Division().getDivisionList(lname)
    else:
        divisionList = Division().getAllowedDivisionList(lname, g.user.mid)

    if divisionList is None:
        return jsonify(success=False), 404

    return jsonify(divisionList)


@division_api.route('/lms/api/v1.0/<lname>/divisions_all', methods=['GET'])
@auth.login_required
def get_divisions(lname):
    """ Для режима 'Научно-исследовательские работы' """
    divisionList = Division().getDivisionList(lname)

    if divisionList is None:
        return jsonify(success=False), 404

    return jsonify(divisionList)