from flask import Flask,jsonify, request, current_app,send_from_directory, g
from flask_restful import Resource,Api
from sqlalchemy import create_engine
from flask import Blueprint
from LMSAPI.api.Models.UserActionLog import UserActionLog
from LMSAPI.api.Views.TokenAPI import auth
from flask_cors import CORS
from LMSAPI.api.Models.File import File 
import pickle

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint



file_api = Blueprint('file_api', __name__)

CORS(file_api)



@file_api.route('/lms/api/v1.0/<lname>/file/People/<int:mid>', methods=['GET'])
@auth.login_required
def getUserFiles(lname,mid):
    f = File(lname)
    return jsonify(f.getUserFiles(mid))

@file_api.route('/lms/api/v1.0/<lname>/file/People/<int:userId>/<filename>', methods=['GET'])
@auth.login_required
def getUserFile(lname,userId,filename):
    file_path = File(lname).getUserFileDirectory(userId)
    ip_address = (
        request.headers.get('X-Forwarded-For') or
        request.headers.get('X-Real-IP') or
        request.environ.get("REMOTE_ADDR")
    )
    return File.send_from_directory(
        lname=lname,
        file_path=file_path,
        file_name=filename,
        action_source=request.environ.get("HTTP_USER_AGENT"),
        login=g.user.id,
        user_mid=g.user.mid,
        ip_address=ip_address
    )