from flask import Flask, jsonify, request, current_app
from flask_restful import Resource, Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.User import User
from LMSAPI.api.Models.Gradebook import Gradebook
from LMSAPI.api.Models.Group import Group
from flask_cors import CORS

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

gradebook_api = Blueprint('gradebook_api', __name__)

CORS(gradebook_api)


# Get all cathedras for a faculty
@gradebook_api.route('/lms/api/v1.0/<lname>/gradebook/<int:uid>/<int:semesterid>', methods=['GET'])
@auth.login_required
def getGradebook(lname, uid, semesterid):
    """Get Gradebook results"""
    g = Gradebook(lname)

    r = g.getGradebook(uid, semesterid)

    return jsonify(r)