# coding=UTF-8
from flask import Blueprint, jsonify
from flask_cors import CORS

from LMSAPI.api.Models.Localization import Localization

localization_api = Blueprint('localization_api', __name__)

CORS(localization_api)


@localization_api.route(
    "/lms/api/v1.0/<lname>/localization",
    methods=["GET"],
)
def get_localization(lname):
    result = Localization(lname).get_users()

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)
