from flask import Blueprint, request, jsonify
from flask_cors import CORS

from LMSAPI.api.Models.Plans import ComplexThemePlanStream
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.utils.access_utils import user_permission_modes


plans_api = Blueprint('plans_api', __name__)

CORS(plans_api)


@plans_api.route('/lms/api/v1.0/<lname>/plans/complex_theme_plan_stream', methods=['GET'])
@auth.login_required
@user_permission_modes("Справочники", "Комплексный тем.план (КТП) по дисциплинам", ["Нет"])
def get_complex_theme_plan_stream(lname):
    complex_theme_plan_stream = ComplexThemePlanStream.create_plan_stream(request.args, lname)
    return jsonify(complex_theme_plan_stream)

