from flask import Flask, jsonify, request, current_app, send_from_directory
from flask_restful import Resource, Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.User import User
from LMSAPI.api.Models.RPD import RPD
from flask_cors import CORS

from LMSAPI.api.utils.access_utils import user_permission_modes

rpd_api = Blueprint("rpd_api", __name__)

CORS(rpd_api)


@rpd_api.route(
    "/lms/api/v1.0/<lname>/rpd/subjects/<int:cid>",
    methods=["GET"],
)
@auth.login_required
@user_permission_modes("Режимы", "Наименования разделов и тем по РПД", ["Нет"])
def getRPDSubjects(lname, cid):
    rpd = RPD(lname)
    result = rpd.getRPDSubjet(cid)
    if result is None:
        return jsonify(success=False), 404
    return jsonify(result)


@rpd_api.route(
    "/lms/api/v1.0/<lname>/rpd/subjects/<int:idcurriculum>/<int:cid>",
    methods=["PUT"],
)
@auth.login_required
def updateRPDSubjects(lname, idcurriculum, cid):
    result = RPD(lname).updateRPDSubjects(request.json, idcurriculum, cid)
    if result is False:
        return jsonify(success=False), 400
    return jsonify(success=True), 200


@rpd_api.route("/lms/api/v1.0/<lname>/rpd/subjects", methods=["POST"])
@auth.login_required
def add_rpd_subjects(lname):
    result = RPD(lname).add_rpd_subject(request.json)
    if result is None:
        return jsonify(success=False), 404
    return jsonify(result)


@rpd_api.route("/lms/api/v1.0/<lname>/rpd/subjects/<oid>", methods=["DELETE"])
@auth.login_required
def delete_rpd_subjects(lname, oid):
    result = RPD(lname).delete_rpd_subjects(oid)
    if result is None:
        return jsonify(success=False), 404
    return jsonify(result)


@rpd_api.route("/lms/api/v1.0/<lname>/rpd/subjects", methods=["PUT"])
@auth.login_required
def update_list_rpd_subjects(lname):
    query_param = request.args.get("main")
    result = RPD(lname).update_items_block(request.json, query_param)
    if result is None:
        return jsonify(success=False), 404
    return jsonify(result)
