from flask import jsonify, current_app, request, g
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from flask_cors import CORS
from LMSAPI.api.Models.Schedule import Schedule
from LMSAPI.api.utils.access_utils import user_permission_modes
from LMSAPI.api.utils.swagger_utils import swagger_doc
from LMSAPI.api.utils.swagger_comments import SwaggerComments

schedule_api = Blueprint("schedule_api", __name__)

CORS(schedule_api)


@schedule_api.route(
    "/lms/api/v1.0/<lname>/schedule/room/<int:roomid>/<scheduledate>", methods=["GET"]
)
def getScheduleRoom(lname, roomid, scheduledate):
    """GET schedule for user and date"""
    s = Schedule(lname)
    scheduleData = s.getScheduleRoom(roomid, scheduledate)
    return jsonify(scheduleData)


@schedule_api.route(
    "/lms/api/v1.0/<lname>/schedule/<int:mid>/<scheduledate>", methods=["GET"]
)
@auth.login_required
def getScheduleD(lname, mid, scheduledate):
    """GET schedule for user and date"""
    s = Schedule(lname)
    scheduleData = s.getSchedule(mid, scheduledate)
    return jsonify(scheduleData)


@schedule_api.route(
    "/lms/api/v1.0/<lname>/schedule/u/<int:mid>/<scheduledate>", methods=["GET"]
)
@auth.login_required
def getSchedule(lname, mid, scheduledate):
    """GET schedule for user and date"""
    s = Schedule(lname)
    scheduleData = s.getSchedule(mid, scheduledate)
    return jsonify(scheduleData)


@schedule_api.route(
    "/lms/api/v1.0/<lname>/schedule/g/<int:gid>/<scheduledate>", methods=["GET"]
)
def getScheduleGroup(lname, gid, scheduledate):
    """GET schedule for user and date"""
    s = Schedule(lname)
    scheduleData = s.getScheduleGroup(gid, scheduledate)
    return jsonify(scheduleData)
    # return jsonify([org.serialize() for org in orgTree]),200,{'Content-Type': 'text/json; charset=utf-8'}


@schedule_api.route(
    "/lms/api/v1.0/<lname>/schedule/<int:idfaculty>/<int:educationyear>/<int:xp_key>/<int:month>",
    methods=["GET"],
)
@auth.login_required
@swagger_doc(SwaggerComments.schedule_api_getScheduleFilter)
def getScheduleFilter(lname, idfaculty, educationyear, xp_key, month):
    """
    Получить расписание занятий по фильтрам
    """
    s = Schedule(lname)
    gid = request.args.get("gid", type=int, default=0)
    scheduleData = s.getScheduleFilter(idfaculty, educationyear, xp_key, month, gid)

    if scheduleData is None:
        current_app.logger.error(
            "Schoolyear "
            + str(xp_key)
            + " /Education year "
            + str(educationyear)
            + " does not exist"
        )
        scheduleData = {}

    return jsonify(scheduleData)


@schedule_api.route(
    "/lms/api/v1.0/<lname>/schedule/t/<int:mid>/<int:weekid>", methods=["GET"]
)
@auth.login_required
@user_permission_modes("Режимы", "Личное расписание преподавателя", ["Нет"])
def getScheduleTeacher(lname, mid, weekid):
    """GET schedule for user and date"""
    s = Schedule(lname)
    scheduleData = s.getScheduleTeacher(mid, weekid)
    return jsonify(scheduleData)


@schedule_api.route("/lms/api/v1.0/<lname>/schedule/vypiska", methods=["GET"])
@auth.login_required
def getScheduleTeacherVypiska(lname):
    s = Schedule(lname)
    trmid = request.args.get("trmid")
    week_id = request.args.get("week_id")
    mid = g.user.mid
    if trmid:
        schedule_data, schedule_data_info = s.get_schedule_teacher_vypiska_per_semester(
            mid, trmid
        )
    elif week_id:
        schedule_data, schedule_data_info = s.get_schedule_teacher_vypiska_per_week(
            mid, week_id
        )
    return jsonify(
        {
            "schedule_data": schedule_data,
            "schedule_data_info": schedule_data_info,
        }
    )
