from flask import Flask,jsonify, request, current_app
from flask_restful import Resource,Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.User import User
from LMSAPI.api.Models.Cathedra import Cathedra
from LMSAPI.api.Models.Group import Group
from LMSAPI.api.Models.Militaryprofession import Militaryprofession
from flask_cors import CORS

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

specialty_api = Blueprint('specialty_api', __name__)

CORS(specialty_api)


# Get all cathedras for a faculty
@specialty_api.route('/lms/api/v1.0/<lname>/specialty/', methods=['GET'])
@auth.login_required
def getMilitaryProfessions(lname):
    """GET with ID of Cathedra to get list of groups"""
    result = Militaryprofession().getMilitaryProfessions(lname)

    if result is None:
        return jsonify(success=False),404

    return jsonify(result)

# Get all cathedras for a faculty
@specialty_api.route('/lms/api/v1.0/<lname>/specialty/<int:id>', methods=['GET'])
@auth.login_required
def getMilitaryProfession(lname,id):
    """GET with ID to get details for a Group"""
    
    mp = Militaryprofession()
    result = mp.getMilitaryProfession(lname,id)

    if result is None:
        return jsonify(success=False),404

    return jsonify(result)

