from typing import Union, Tuple, Any

from flask import jsonify, request, current_app, g, send_from_directory
from flask import Blueprint

from LMSAPI.api.Models.File import File
# from LMSAPI.api.Views.TokenAPI import auth
# from LMSAPI.api.Models.Cathedra import Cathedra
from flask_cors import CORS
import json

from LMSAPI.api.Models.TrainingDirection import TrainingDirection
from LMSAPI.api.Views.TokenAPI import auth

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

traindirs_api = Blueprint('traindirs_api', __name__)

CORS(traindirs_api)


# Get all train areas
@traindirs_api.route('/lms/api/v1.0/<lname>/all_train_dirs', methods=['GET'])
def getAllTrainDirs(lname):
    """GET a list of train directions"""
    TD = TrainingDirection(lname)
    result = TD.get_all_dirs()

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@traindirs_api.route('/lms/api/v1.0/<lname>/train_dirs/<int:dir_id>', methods=['GET'])
def get_dir(lname: str, dir_id: int) -> Union[Tuple[Any, int], dict]:
    TD = TrainingDirection(lname)
    result = TD.get_train_dir(lname, dir_id)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@traindirs_api.route('/lms/api/v1.0/<lname>/train_dirs/<int:train_dir_id>', methods=['PUT'])
def update_dir(lname: str, train_dir_id: int) -> Union[Tuple[Any, int], dict]:
    TD = TrainingDirection(lname)
    result = TD.update_train_dir(lname, request.json, train_dir_id)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)

