from flask import current_app
from sqlalchemy import text


class Database:
    def __init__(self, db_name: str):
        self.connection = current_app.ms.db(db_name).connect()

    def execute_select(self, sql_query: str) -> list:
        statement = text(sql_query)
        query = self.connection.execute(statement)
        if query.cursor.rowcount == 0:
            return [{key: None for key in query.keys()}]
        res = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        for i in res:
            i["hours"] = float(i["hours"])
        return res
