swagger_registry = {"paths": {}}


def swagger_doc(doc: dict):
    """
    Декоратор: сохраняет документацию в функцию,
    не трогает Flask context.
    """
    def decorator(func):
        func.__swagger_doc__ = doc
        return func
    return decorator


def finalize_swagger(app):
    """
    После того как все роуты зарегистрированы,
    пройтись по url_map и собрать swagger_registry.
    """
    for rule in app.url_map.iter_rules():
        endpoint = app.view_functions[rule.endpoint]
        doc = getattr(endpoint, "__swagger_doc__", None)
        if doc:
            path = rule.rule.replace("<", "{").replace(">", "}")
            methods = [m for m in rule.methods if m in ("GET", "POST", "PUT", "DELETE", "PATCH")]
            for method in methods:
                if path not in swagger_registry["paths"]:
                    swagger_registry["paths"][path] = {}
                swagger_registry["paths"][path][method.lower()] = doc

class SwaggerUtils:
    tags = [
        {
            "name": "Постоянный состав",
            "description": "[Данный режим](http://10.120.7.20/permanent_stuff)"
        },
        {
            "name": "Переменный состав",
            "description": "[Данный режим](http://10.120.7.20/variable_stuff)"
        },
        {
            "name": "Расписание занятий",
            "description": "[Данный режим](http://10.120.7.20/schedule)"
        },
        {
            "name": "Научно-исследовательские работы",
            "description": "[Данный режим](http://10.120.7.20/scientific_work)"
        },
        {
            "name": "Работы/проекты обучающегося",
            "description": "[Данный режим](http://10.120.7.20/student_projects_teacher)"
        },
        {
            "name": "Электронные учебно-методические комплексы дисциплин",
            "description": "[Данный режим](http://10.120.7.20/umkTeacher)",
        }
    ]

    security = {"basicAuth": []}

    defoult_400 = {"description": "⚠️ Неверный запрос"}

    defoult_401 = {"description": "🚫 Неавторизован"}

    defoult_404 = {
        "description": "⚠️ Данные не найдены",
        "schema": {
            "type": "object",
            "properties": {
                "success": {
                    "type": "boolean",
                    "example": False
                }
            }
        }
    }
